#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=CheckDriveFileAvail
step=DriveFileAvailISDC
transferdelay=3 #days

set -C

# check if script is already running
lockfile=$lockpath/lock-$program.txt
checklock 

# get todo list
gettodo 


for (( s=0 ; s < $num ; s++ ))
do
   night=${primaries[$s]}
   currentnight=`date +%Y%m%d`
   checknight=`echo " $currentnight - $transferdelay " | bc -l`
   
   setstatus "start" 

   auxpath=$auxdata"/"`echo $night | cut -c 1-4`/`echo $night | cut -c 5-6`/`echo $night | cut -c 7-8`
   drivefile=$auxpath/$night".DRIVE_CONTROL_TRACKING_POSITION.fits"

   test -e $drivefile 
   check1=$?
   case $check1 in
      0)   printprocesslog "INFO found "$drivefile
           ;;
      *)   if [ $night -lt $checknight ]
           then 
              printprocesslog "WARN "$drivefile" missing (check1="$check1")."
              check=$check1
           else
              check="no"
              printprocesslog "INFO "$drivefile" missing (check1="$check1")."
           fi
           ;;
   esac

   setstatus "stop" 
done

finish 

