#!/bin/bash

# option 
doupdate="yes" # update all entries (needed when new fields have been added)
#doupdate="no" # fill only entries which are not yet existing (default)

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 with option doupdate="$doupdate

logfile=$runlogpath"/FillTemp-"$datetime".log"
date >> $logfile

# setup to use ftools
source $HEADAS/headas-init.sh

# check if software is available
if ! ls $factpath/fitsdump >/dev/null 2>&1
then 
   printprocesslog "ERROR "$factpath"/fitsdump is not available."
   finish
fi


# get last 3, 6 or 9 nights
dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` `date +%Y/%m/%d --date="-60hour"` \
#        `date +%Y/%m/%d --date="-84hour"` `date +%Y/%m/%d --date="-108hour"` `date +%Y/%m/%d --date="-132hour"` \
#        `date +%Y/%m/%d --date="-156hour"` `date +%Y/%m/%d --date="-180hour"` `date +%Y/%m/%d --date="-204hour"` \
        )
dates=( `find -L $ziprawdata -mindepth 3 -type d | sort | sed "s/\${ziprawdata_for_sed}//g" | sed -e 's/^\///'` ) #all available dates in /loc_data/zipraw
printprocesslog "INFO processing the following night(s): "${dates[@]}
echo  `date`": processing the following night(s): "${dates[@]} >> $logfile 2>&1

echo ${dates[@]}

cd $mars

# do filling of aux data 
for date in ${dates[@]}
do 
   auxdir=$auxdata/$date
   runnumber=`echo $date | sed -e 's/\///g'`
   if [ $runnumber -lt 20120328 ]
   then
      continue
   fi

   # check if aux files are available from that night
   if ! [ -d $auxdir ]
   then
      printprocesslog "INFO no data available in "$auxdir
      continue
   else
      printprocesslog "INFO processing files in "$auxdir
   fi

   # get file numbers from DB
   #   but only for not-corrupted files
   query="SELECT fRunID from RunInfo WHERE fNight="$runnumber" AND fFitsFileErrors=0 "
   if [ "$doupdate" = "no" ]
   then
      query=$query" AND ISNULL(fCameraTempMean) "
   fi

   printprocesslog "DEBUG get filenumbers from DB: QUERY: "$query
   filenumbers=( `sendquery $query` )
   if [ ${#filenumbers} -eq 0 ]
   then
      printprocesslog "INFO No files found in the DB for night "$date
      continue
   fi

   magicweatherfile=$auxdir/$runnumber.MAGIC_WEATHER_DATA.fits
   if ! [ -e $magicweatherfile ]
   then 
      printprocesslog "WARN "$magicweatherfile" not found."
      echo "WARN "$magicweatherfile" not found."
   else
      weathernumerrors=`fverify $magicweatherfile 2>/dev/null | grep -o '[0-9][ ]error(s)'  | grep -E -o '[0-9]'`
      if [ $weathernumerrors -gt 0 ]
      then 
         printprocesslog "WARN for $magicweatherfile fverify returned "$weathernumerrors" error(s)."
      fi
   fi

   fsctempfile=$auxdir/$runnumber.FSC_CONTROL_TEMPERATURE.fits
   if ! [ -e $fsctempfile ]
   then 
      printprocesslog "WARN "$fsctempfile" not found."
      echo "WARN "$fsctempfile" not found."
   else
      tempnumerrors=`fverify $fsctempfile 2>/dev/null | grep -o '[0-9][ ]error(s)'  | grep -E -o '[0-9]'`
      if [ $tempnumerrors -gt 0 ]
      then 
         printprocesslog "WARN for $fsctempfile fverify returned "$tempnumerrors" error(s)."
      fi
   fi

   # fill auxiliary information for files
   for filenum in ${filenumbers[@]}
   do
      printprocesslog "INFO processing file number "$runnumber"_"`printf %03d $filenum`
      echo  `date`": processing file number "$runnumber"_"`printf %03d $filenum` >> $logfile 2>&1
      # get information from rawfile
      rawfile=$ziprawdata/$date/$runnumber"_"`printf %03d $filenum`.fits.gz
      if ! [ -e $rawfile ]
      then 
         printprocesslog "ERROR: "$rawfile" not found."
         continue
      fi
      #checkfitsfile=`fverify $rawfile  2>/dev/null | grep '0 error(s)'`
      #if [ "$checkfitsfile" == "" ]
      #then
      #   numfitserrors=1
      #   printprocesslog "WARN: "$rawfile" probably corrupted."
      #   continue
      #fi
      runtype=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep RUNTYPE | grep -E -o "['][a-z-]+[']" | sed -e "s/'//g"`
      mjdrefraw=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep 'MJDREF' | grep -E -o '[0-9]{5}'`
      tstarti=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep 'TSTARTI' | grep -E -o '[0-9]{5}'`
      tstartf=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep 'TSTARTF' | grep -E -o '0[.][0-9]+'`
      tstopi=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep 'TSTOPI' | grep -E -o '[0-9]{5}'`
      tstopf=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep 'TSTOPF' | grep -E -o '0[.][0-9]+'`
      if [ "$tstarti" == "" ] || [ "$tstopi" == "" ] || [ "$tstartf" == "" ] || [ "$tstopf" == "" ]
      then 
         printprocesslog "WARN: "$rawfile": one of the following keywords is empty or 0: TSTARTI TSTARTF TSTOPI TSTOPF "
         continue
      fi
      # assuming that at least TSTARTI and TSTOPI are consistent
      #echo $rawfile
      #echo $tstarti
      #echo $tstopi
      #echo $tstartf
      #echo $tstopf
      if [ $tstarti -gt 30000 ]
      then 
         tstart=`echo " $tstarti + $tstartf - 40587 " | bc -l`
         tstart2=`echo " $tstarti + $tstartf - 40587 - 0.00011574 " | bc -l`  # 10 sec
         #tstart2=`echo " $tstarti + $tstartf - 40587 - 0.000023148 " | bc -l` # 2 sec
         tstop=`echo " $tstopi + $tstopf - 40587 " | bc -l`
      else
         tstart=`echo " $tstarti + $tstartf " | bc -l`
         tstart2=`echo " $tstarti + $tstartf - 0.00011574 " | bc -l`  # 10 sec
         #tstart2=`echo " $tstarti + $tstartf - 0.000023148 " | bc -l` # 2 sec
         tstop=`echo " $tstopi + $tstopf " | bc -l`
      fi

      # build query to update runinfo in DB
      query="UPDATE RunInfo SET "

      # get information from fsc: T[31]
      if [ -e $fsctempfile ] && [ $tempnumerrors -eq 0 ]
      then 
         fsctemps=( `root -q -b -l fact/camtemp.C\("\"$fsctempfile\""\,$tstart\,$tstop\) | grep "result" | grep -E -o '[0-9]+[.]?[0-9]*'` )
         echo ${fsctemps[@]}
         if [ "${fsctemps[0]}" == "" ]
         then 
            query=$query"fCameraTempMean=NULL"
         else
            query=$query"fCameraTempMean="${fsctemps[0]}
         fi
         if [ "${fsctemps[1]}" == "" ]
         then 
            query=$query", fCameraTempRms=NULL"
         else
            query=$query", fCameraTempRms="${fsctemps[1]}
         fi
         if [ "${fsctemps[2]}" == "" ]
         then 
            query=$query", fCameraTempRmsMean=NULL"
         else
            query=$query", fCameraTempRmsMean="${fsctemps[2]}
         fi
      else
         query=$query" fCameraTempMean=NULL"
         query=$query", fCameraTempRms=NULL"
         query=$query", fCameraTempRmsMean=NULL"
      fi
      #fCameraTempMeanRms: mean of rms of single sensors
      
      # get information from weather: T
      if [ -e $magicweatherfile ] && [ $weathernumerrors -eq 0 ]
      then 
         mtemps=( `root -q -b -l fact/magictemp.C\("\"$magicweatherfile\""\,$tstart\,$tstop\) | grep "result" | grep -E -o '[0-9]+[.]?[0-9]*'` )
         if [ "${mtemps[0]}" == "" ]
         then 
            query=$query", fOutsideTempMean=NULL"
         else
            query=$query", fOutsideTempMean="${mtemps[0]}
         fi
         if [ "${mtemps[1]}" == "" ]
         then 
            query=$query", fOutsideTempRms=NULL"
         else
            query=$query", fOutsideTempRms="${mtemps[1]}
         fi
      else
         query=$query", fOutsideTempMean=NULL"
         query=$query", fOutsideTempRms=NULL"
      fi
      
      # add where condition
      query=$query" WHERE fNight="$runnumber" AND fRunID="$filenum
      
      echo $query
      # send query to DB
      sendquery >/dev/null
   done
done

finish


