#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=CheckRatesFileAvail
step=RatesFileAvailISDC
transferdelay=3 #days

set -C

# check if script is already running
lockfile=$lockpath/lock-$program.txt
checklock 

# get todo list
gettodo 


for (( s=0 ; s < $num ; s++ ))
do
   night=${primaries[$s]}
   setstatus "start" 

   auxpath=$auxdata"/"`echo $night | cut -c 1-4`/`echo $night | cut -c 5-6`/`echo $night | cut -c 7-8`
   ratesfile=$auxpath/$night".FTM_CONTROL_TRIGGER_RATES.fits"

   test -e $ratesfile 
   check1=$?
   case $check1 in
      0)   printprocesslog "INFO found "$ratesfile
           ;;
      *)   if [ $night -lt $checknight ]
           then 
              printprocesslog "WARN "$ratesfile" missing (check1="$check1")."
              check=$check1
           else
              check="no"
              printprocesslog "INFO "$ratesfile" missing (check1="$check1")."
           fi
           ;;
   esac

   setstatus "stop" 
done

finish 

