#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=RunCallisto
step=Callisto

set -C

for (( i=0; i<100; i++ ))
do 
   # get todo list
   gettodo "1"

   # get all needed variables
   night=${primaries[0]}
   seqid=${primaries[1]}
   nightpath=`echo $night | cut -c 1-4`"/"`echo $night | cut -c 5-6`"/"`echo $night | cut -c 7-8`
   seqnum=$night"_"`printf %03d $seqid`

   # check if script is already running
   lockfile=$lockpath"/lock-"$program"-"$seqnum".txt"
   checklock continue
   printprocesslog "INFO got todo with try #"$i
   break
done

# get all needed paths and files
delays="resources/delays-20150217.txt"
drstimefiles=`ls $drstimepath | sort`
for drstimefile in $drstimefiles
do 
   num=`echo $drstimefile | cut -c 1-8`
   if [ $num -gt $night ]
   then
      break
   fi
   drstime=$drstimepath/$drstimefile
done
   
seqfile=$seqpath"/"$nightpath"/"$seqnum".seq"
outpath=$datapath"/callisto/"$nightpath
makedir $outpath
logfile=$outpath"/"$seqnum"-calibration.log"

cd $mars

# run callisto 
printprocesslog "INFO starting callisto.C for sequence "$seqnum
setstatus "start" 

printprocesslog "DEBUG root -q -b fact/analysis/callisto.C\("\"$seqfile\""\,"\"$outpath\""\,\""$drstime"\"\,\""$delays"\"\) | tee $logfile "
check1=`root -q -b fact/analysis/callisto.C\("\"$seqfile\""\,"\"$outpath\""\,\""$drstime"\"\,\""$delays"\"\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO callisto was successful for sequence "$seqnum" (check1=$check1)"
        ;;
   *)   printprocesslog "ERROR callisto.C failed for sequence "$seqnum" (check1=$check1)"
        check=$check1
        ;;
esac

setstatus "stop" 

finish 

