#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=BuildSequences

# removed, as this is taken care of in crontab
#set -C
## check if script is already running
#lockfile=$lockpath/lock-$program.txt
#checklock 

logfile=$runlogpath"/BuildSequences-"$datetime".log"
date >> $logfile

cd $mars

check1=`root -q -b fact/processing/buildseqentries.C+\("\"$datapath\""\,"\"$seqpath\""\,1\,kFALSE\) | tee $logfile | intgrep`

case $check1 in
   1)   printprocesslog "INFO built sequences was successfully (check1=$check1)"
        ;;
   0)   printprocesslog "WARN connection to DB failed (check1=$check1)"
        #check="no"
        ;;
   *)   printprocesslog "ERROR buildseqentries.C failed (check1=$check1)"
        #check=$check1
        ;;
esac

# update run counts in SequenceInfo table
# runs in sequence
query="UPDATE SequenceInfo LEFT JOIN RunInfo USING(fNight, fSequenceID) "
query=$query"SET fNumRuns=(SELECT COUNT(*) FROM RunInfo "
query=$query"WHERE fSequenceID=SequenceInfo.fSequenceID AND fNight=SequenceInfo.fNight) "
printprocesslog "INFO Updating SequenceInfo with number of runs."
sendquery
# raw files avail ISDC
query="UPDATE SequenceInfo LEFT JOIN RunInfo USING(fNight, fSequenceID) "
query=$query"SET fNumRawfilesAvailISDC=(SELECT COUNT(*) FROM RunInfo "
query=$query"LEFT JOIN RawFileAvailISDCStatus USING(fNight, fRunID) "
query=$query"WHERE fSequenceID=SequenceInfo.fSequenceID AND fNight=SequenceInfo.fNight "
query=$query"AND NOT ISNULL(RawFileAvailISDCStatus.fStartTime) "
query=$query"AND NOT ISNULL(RawFileAvailISDCStatus.fStopTime) "
query=$query"AND ISNULL(RawFileAvailISDCStatus.fReturnCode)) "
printprocesslog "INFO Updating SequenceInfo with number of available files."
sendquery

finish 

