#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=CheckAuxFilesAvail
step=AuxFilesAvailISDC

set -C

# check if script is already running
lockfile=$lockpath/lock-$program.txt
checklock 

# get todo list
gettodo 


for (( s=0 ; s < $num ; s++ ))
do
   night=${primaries[$s]}
   setstatus "start" 

   auxpath=$auxdata"/"`echo $night | cut -c 1-4`/`echo $night | cut -c 5-6`/`echo $night | cut -c 7-8`
   drivefile=$auxpath/$night".DRIVE_CONTROL_TRACKING_POSITION.fits"
   weatherfile=$auxpath/$night".MAGIC_WEATHER_DATA.fits"
   ratesfile=$auxpath/$night".FTM_CONTROL_TRIGGER_RATES.fits"
   temperaturefile=$auxpath/$night".FSC_CONTROL_TEMPERATURE.fits"
   humidityfile=$auxpath/$night".FSC_CONTROL_HUMIDITY.fits"

   test -e $drivefile 
   check1=$?
   test -e $weatherfile 
   check2=$?
   test -e $ratesfile 
   check3=$?
   test -e $temperaturefile 
   check4=$?
   test -e $humidityfile 
   check5=$?
   
   totalcheck=`echo $check1 + $check2 + $check3 + $check4 + $check5 | bc -l`
   totalcheck2=${check1}${check2}${check3}${check4}${check5}

   case $totalcheck in
      0)   printprocesslog "INFO found auxfiles for night "$night"."
           ;;
      *)   if [ $night -lt $checknight ]
           then 
              printprocesslog "WARN "$totalcheck" auxiliary files missing ("$totalcheck2") for night "$night"."
              check=$totalcheck2
           else
              check="no"
              printprocesslog "INFO "$totalcheck" auxiliary files missing ("$totalcheck2") for night "$night"."
           fi
           ;;
   esac

   setstatus "stop" 
done

finish 

