#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=StarEventsFilled
step=StarEventsFilled


# for refilling DB from scratch several processes are useful
# therefore two commandline options have been implemented: 
#   numjobs: number of process that are started from FillEvent.sh
#   numjob: number of the current process [0 to numjobs-1]
if [ "$1" != "" ]
then
   numjobs=$1
   if [ "$2" == "" ]
   then
      echo "missing second argument"
      finish
   else
      numjob=$2
   fi
   if [ $2 -gt $(($1 - 1)) ]
   then
      echo "you cannot start a job with a number larger than the number of jobs you specified"
      finish
   fi
else
   numjobs=1
   numjob=0
fi 


set -C

# check if script is already running
lockfile=$lockpath/lock-$numjob-$program.txt
checklock 

# get todo list
gettodo 

logfile=$runlogpath"/FillStarEvents-"$numjob"-"$datetime".log"
date >> $logfile

# get mysql version with which connection is possible
export LD_LIBRARY_PATH=/swdev_nfs/mysql++-3.2.4:/swdev_nfs/mysql-5.7.23-linux-glibc2.12-x86_64/lib:/swdev_nfs/libnova/lib/:$LD_LIBRARY_PATH

# setup file for root2sql
starrc=`ls \`dirname $0\`/../Setup/star.rc`

for (( s=0 ; s < $num ; s++ ))
do
   night=${primaries[$s+$s]}
   runid=${primaries[$s+$s+1]}
   
   if [ $(($runid % $numjobs)) -ne $numjob ]
   then
      printprocesslog "INFO processing only part of the data (runid "$runid", numjobs "$numjobs", "$numjob") -> continue"
      continue
   fi
   
   setstatus "start" 
   if [ $numchanged -eq 0 ]
   then
      printprocesslog "INFO "$numchanged" rows were changed in DB => "$night"_"$runid" is already processed => continue."
      continue
   fi
   
   # get file id and star-file name
   #echo "INFO filling star events for "$night"_"$runid
   printprocesslog "INFO filling star events for "$night"_"$runid
   echo "INFO filling star events for "$night"_"$runid >> $logfile
   night2=`echo $night | cut -c 1-4`/`echo $night | cut -c 5-6`/`echo $night | cut -c 7-8`
   starfile=$datapath/star/$night2/$night"_"`printf %03d $runid`"_I.root"

   # some runs have problems, e.g. double event numbers
   #  these have an ignore-errors flag set in the DB
   ignoreoption=""
   query="SELECT fIgnoreErrors FROM StarEventsFilledStatus WHERE fNight="$night" AND fRunID="$runid
   ignore=`sendquery`
   if [ $ignore -eq 1 ]
   then 
      ignoreoption="--ignore-errors"
   fi
   
   # fill star files to DB
   printprocesslog  "INFO /swdev_nfs/FACT++.r19188-bin/root2sql -C $starrc $starfile"
   /swdev_nfs/FACT++.r19188-bin/root2sql -C $starrc $ignoreoption $starfile >> $logfile 2>&1
   check1=$?
   case $check1 in
      0)   printprocesslog "INFO successfully filled "$starfile
           ;;
      *)   printprocesslog "ERROR could not fill "$starfile
           check=$check1
           ;;
   esac

   setstatus "stop" 
done

finish 

