#!/bin/bash

# option whether to fill all row or only those where information is missing
# $doupdate might be given as environment variable
if [ "$doupdate" = "" ]
then
   doupdate="yes" # update all entries (needed when new fields have been added)
   doupdate="no" # fill only entries which are not yet existing (default)
fi

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 with option doupdate="$doupdate

logfile=$runlogpath"/FillRates-"$datetime".log"
date >> $logfile

# check if software is available
if ! ls $factpath/fitsdump >/dev/null 2>&1
then 
   printprocesslog "ERROR "$factpath"/fitsdump is not available."
   finish
fi

# get dates
if [ "$certaindate" != "" ]
then
   getdates $certaindate
else
   # get all night
   #getdates "all"
   # get last 6 nights
   getdates 6
fi


printprocesslog "INFO processing the following night(s): "${dates[@]}
echo  `date`": processing the following night(s): "${dates[@]} >> $logfile 2>&1

cd $mars

# do filling of aux data 
for date in ${dates[@]}
do 
   auxdir=$auxdata/$date
   runnumber=`echo $date | sed -e 's/\///g'`
   if [ $runnumber -lt 20120328 ]
   then
      continue
   fi

   # get file numbers from DB
   #   but only for not-corrupted files
   query="SELECT fRunID from RunInfo WHERE fNight="$runnumber" AND fFitsFileErrors=0 AND fRunTypeKey=1 "
   if [ "$doupdate" = "no" ]
   then
      query=$query" AND ISNULL(fNum27Sec) "
   fi
   printprocesslog "DEBUG get filenumbers from DB: QUERY: "$query

   filenumbers=( `sendquery $query` )
   printprocesslog "INFO processing "${#filenumbers[@]}" files from date "$date
   echo "INFO processing "${#filenumbers[@]}" files from date "$date >> $logfile 2>&1
   # proceed only if there are files available
   if [ ${#filenumbers} -eq 0 ]
   then
      printprocesslog "INFO No files found in the DB for night "$date
      continue
   fi

   # fill 
   counter=0
   for filenum in ${filenumbers[@]}
   do
      printprocesslog "INFO processing file number "$runnumber"_"`printf %03d $filenum`
      echo  `date`": processing file number "$runnumber"_"`printf %03d $filenum` >> $logfile 2>&1
      
      cfile=$datapath"/callisto/"$date"/"$runnumber"_"`printf %03d $filenum`"_C.root"
      if ! [ -e $cfile ]
      then
         printprocesslog "INFO "$cfile" does not yet exist"
         continue
      fi
      
      printprocesslog "INFO filling rates from " $cfile
      rates=( `root -q -b -l fact/processing/swtrig.C\("\"$cfile\""\) | grep "result" | grep -E -o '[0-9]+'` )

      # build query to update runinfo in DB
      query="UPDATE RunInfo SET "

      if [ "${rates[0]}" == "" ]
      then 
            query=$query"fNum27Sec=NULL, "
            query=$query"fNumThreshold50=NULL, "
            query=$query"fNumThreshold100=NULL, "
            query=$query"fNumThreshold200=NULL, "
            query=$query"fNumThreshold350=NULL, "
            query=$query"fNumThreshold500=NULL, "
            query=$query"fNumThreshold750=NULL, "
            query=$query"fNumThreshold1000=NULL, "
            query=$query"fNumThreshold1250=NULL, "
            query=$query"fNumThreshold2500=NULL, "
            query=$query"fNumThreshold5000=NULL, "
            query=$query"fNumThreshold10000=NULL, "
            query=$query"fNumThreshold20000=NULL"
      else
            query=$query"fNum27Sec="${rates[0]}", "
            query=$query"fNumThreshold50="${rates[1]}", "
            query=$query"fNumThreshold100="${rates[2]}", "
            query=$query"fNumThreshold200="${rates[3]}", "
            query=$query"fNumThreshold350="${rates[4]}", "
            query=$query"fNumThreshold500="${rates[5]}", "
            query=$query"fNumThreshold750="${rates[6]}", "
            query=$query"fNumThreshold1000="${rates[7]}", "
            query=$query"fNumThreshold1250="${rates[8]}", "
            query=$query"fNumThreshold2500="${rates[9]}", "
            query=$query"fNumThreshold5000="${rates[10]}", "
            query=$query"fNumThreshold10000="${rates[11]}", "
            query=$query"fNumThreshold20000="${rates[12]}
      fi
      
      # add where condition
      query=$query" WHERE fNight="$runnumber" AND fRunID="$filenum
      
      # send query to DB
      sendquery >/dev/null
      
      counter=`echo " $counter + 1 " | bc -l`
   done
   #echo "processed "$counter" files."
done

finish


