#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

root=/opt/root_svn/bin/thisroot.sh
source $root

anapath=/loc_data/analysis
auxpath=/loc_data/aux

printprocesslog "INFO get list of calibrated files"

calfiles=( `find $anapath -type f -name '*_C.root' 2>/dev/null | grep -v failed_stuff | sort` )
if [ ${#calfiles[@]} -eq 0 ]
then
   printprocesslog "INFO no calibrated files available "
   finish
fi
starfiles=( `find $anapath -type f -name '*_I.root' 2>/dev/null | grep -v failed_stuff | sort` )
if [ ${#starfiles[@]} -eq 0 ]
then
   printprocesslog "INFO no star files available "
   finish
fi


if [ ${#starfiles[@]} -lt ${#calfiles[@]} ] 
then
   for calfile in ${calfiles[@]}
   do 
      starfile=`echo $calfile | sed -e 's/callisto/star/' -e 's/_C/_I/'`
      if ! ls $starfile >/dev/null 2>&1
      then
         echo $starfile" is missing -> reprocess. "
         source=`echo $starfile | cut -d/ -f4`
         seqfile="/loc_data/analysis/sequences/"`echo $starfile | cut -d/ -f6-8`"/"`echo $starfile | cut -d/ -f9 | cut -dI -f1 | sed -e 's/_//2'`".seq"
         #echo $source" "$seqfile
         `dirname $0`/RunStar.sh $source $seqfile 
         if ! ls $starfile >/dev/null 2>&1
         then 
            echo "  failed: check log "`echo $starfile | sed -e 's/_I.root/-images.log/'`
            echo "          check calfile "$calfile
         fi
         echo ""
      fi
   done
fi




