#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 $1"

#root=/opt/root_svn/bin/thisroot.sh
#source $root
#factpath=/home/fact/FACT++.in-run-fad-loss
export LD_LIBRARY_PATH=./:$LD_LIBRARY_PATH

mars=/home/fact/SW.automatic.processing/Mars.svn.2013.04.29
cd $mars

if ! [ "$1" = "run" ] && ! [ "$1" = "night" ]
then 
   #echo "wrong option "$1" (only min and nights valid)."
   echo "wrong option "$1" (only run and night valid)."
   finish
fi

if [ "$1" = "run" ]
then 
   tablename=$resulttable1
   timebins=( 5 10 20 30 40 60 90 120 180 240 300 360 )
   timename="min"
fi

if [ "$1" = "night" ]
then
   tablename=$resulttable2
   timebins=( 1 2 3 4 5 6 7 8 9 10 )
   timename="night"
fi

# possibility to give table name as second option
if [ "$2" != "" ]
then 
   tablename=$2
else
   printprocesslog "INFO no second option given -> using table resulttable1 or resulttable2 for producing plots. "
fi

# get current hour
hour=`date +%k`
if [ $hour -le 7 ] || [ $hour -ge 19 ]
then
   dates=( `date +%Y/%m/%d --date="-12hour"` )
else
   # get last 3, 6 or 9 nights
   dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` `date +%Y/%m/%d --date="-60hour"` \
   #        `date +%Y/%m/%d --date="-84hour"` `date +%Y/%m/%d --date="-108hour"` `date +%Y/%m/%d --date="-132hour"` \
   #        `date +%Y/%m/%d --date="-156hour"` `date +%Y/%m/%d --date="-180hour"` `date +%Y/%m/%d --date="-204hour"` \
           )
fi
#dates=( `find -L $auxdata -mindepth 3 -type d | sort -r | sed "s/\${auxdata_for_sed}//g" | sed -e 's/^\///'` ) #all available dates in /loc_data/zipraw

#dates=( "2013/08/31" )

# source info on daq in /loc_data/analysis/sources.txt 
#    (dump of DB scheduling.sources)


#echo ${dates[@]}
for date in ${dates[@]}
do 
   date2=`echo $date | sed -e 's/\///g'`
   if [ $date2 -le $firstnight ]
   then
      continue
   fi
   #echo "date: "$date
   query="SELECT fSourceKEY FROM RunInfo WHERE fNight="$date2" AND fSourceKey > 0 AND fRunTypeKEY=1 GROUP BY fSourceKey "
   sources=( `sendquery` )
   printprocesslog "INFO process "$date" -> sources: "${sources[@]}
   for source in ${sources[@]}
   do 
      #echo $source
      printprocesslog "INFO processing files for source "$source
      outpath=$anapath/lightcurves/$date
      makedir $outpath

      for timebin in ${timebins[@]}
      do 
         # doing the plots for one night
         logfile=$outpath"/lightcurve"$source"_"$timebin$timename"_"$date2".log"
         outfile=$outpath"/lightcurve"$source"_"$timebin$timename"_"$date2".root"
         #echo $outfile
         printprocesslog "INFO starting lightcurve.C+ for source "$source" timebin "$timebin" "$timename" night "$date2
      
	 check1=`root -q -b fact/analysis/lightcurve.C+\($source\,$date2\\,$date2\,$timebin\,"\"$tablename"\"\,"\"$outfile\""\,kFALSE\) | tee $logfile | intgrep`
      
         case $check1 in
            0)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin "$timebin" "$timename" night "$date2" (check1=$check1)"
                 if ! ./showplot -b --save-as-png $outfile >/dev/null
                 then
                    printprocesslog "WARN showplot -b --save-as-png "$outfile" failed."
                 fi
                 ;;
            1)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin "$timebin" "$timename" night "$date2", but nothing to plot (check1=$check1)"
                 ;;
            *)   printprocesslog "ERROR lightcurve.C failed for source "$source" timebin "$timebin" "$timename" night "$date2" (check1=$check1)"
                 ;;
         esac

         
         # doing the plots for last week 
         lastweek=`date +%Y%m%d --date="$date -1 week"`
         logfile=$outpath"/lightcurve"$source"_"$timebin$timename"_week.log"
         outfile=$outpath"/lightcurve"$source"_"$timebin$timename"_week.root"
         #echo $outfile
         printprocesslog "INFO starting lightcurve.C+ for source "$source" timebin "$timebin" "$timename" night "$date2" last week ("$lastweek")"
      
	 check1=`root -q -b fact/analysis/lightcurve.C+\($source\,$lastweek\\,$date2\,$timebin\,"\"$tablename"\"\,"\"$outfile\""\,kFALSE\) | tee $logfile | intgrep`
      
         case $check1 in
            0)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin "$timebin" "$timename" night "$date2" last week (check1=$check1)"
                 #./showplot -b --save-as-png $outfile
                 if ! ./showplot -b --save-as-png $outfile >/dev/null
                 then
                    printprocesslog "WARN showplot -b --save-as-png "$outfile" failed."
                 fi
                 ;;
            1)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin "$timebin" "$timename" night "$date2" last week, but nothing to plot (check1=$check1)"
                 ;;
            *)   printprocesslog "ERROR lightcurve.C failed for source "$source" timebin "$timebin" "$timename" night "$date2" last week (check1=$check1)"
                 ;;
         esac

         # doing the plots for all nights
         logfile=$outpath"/lightcurve"$source"_"$timebin$timename"_all.log"
         outfile=$outpath"/lightcurve"$source"_"$timebin$timename"_all.root"
         #echo $outfile
         printprocesslog "INFO starting lightcurve.C+ for source "$source" timebin "$timebin" "$timename" night "$date2" all nights"
      
	 check1=`root -q -b fact/analysis/lightcurve.C+\($source\,$firstnight\\,$date2\,$timebin\,"\"$tablename"\"\,"\"$outfile\""\,kFALSE\) | tee $logfile | intgrep`
      
         case $check1 in
            0)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin "$timebin" "$timename" night "$date2" all nights (check1=$check1)"
                 #./showplot -b --save-as-png $outfile
                 if ! ./showplot -b --save-as-png $outfile >/dev/null
                 then
                    printprocesslog "WARN showplot -b --save-as-png "$outfile" failed."
                 fi
                 ;;
            1)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin "$timebin" "$timename" night "$date2" all nights, but nothing to plot (check1=$check1)"
                 ;;
            *)   printprocesslog "ERROR lightcurve.C failed for source "$source" timebin "$timebin" "$timename" night "$date2" all nights (check1=$check1)"
                 ;;
         esac
      done
      
      
      # doing nightly plots
      
      # doing the plots for one night
      logfile=$outpath"/lightcurve"$source"_1night_"$date2".log"
      outfile=$outpath"/lightcurve"$source"_1night_"$date2".root"
      #echo $outfile
      printprocesslog "INFO starting lightcurve.C+ for source "$source" 1 night for night "$date2
   
      check1=`root -q -b fact/analysis/lightcurve.C+\($source\,$date2\\,$date2\,-1\,"\"$tablename"\"\,"\"$outfile\""\,kFALSE\) | tee $logfile | intgrep`
   
      case $check1 in
         0)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin 1 night for night "$date2" (check1=$check1)"
              if ! ./showplot -b --save-as-png $outfile >/dev/null
              then
                 printprocesslog "WARN showplot -b --save-as-png "$outfile" failed."
              fi
              ;;
         1)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin 1 night for night "$date2", but nothing to plot (check1=$check1)"
              ;;
         *)   printprocesslog "ERROR lightcurve.C failed for source "$source" timebin 1 night for night "$date2" (check1=$check1)"
              ;;
      esac

      
      # doing the plots for last week 
      lastweek=`date +%Y%m%d --date="$date -1 week"`
      logfile=$outpath"/lightcurve"$source"_1night_week.log"
      outfile=$outpath"/lightcurve"$source"_1night_week.root"
      #echo $outfile
      printprocesslog "INFO starting lightcurve.C+ for source "$source" timebin 1 night for night "$date2" last week ("$lastweek")"
   
      check1=`root -q -b fact/analysis/lightcurve.C+\($source\,$lastweek\\,$date2\,-1\,"\"$tablename"\"\,"\"$outfile\""\,kFALSE\) | tee $logfile | intgrep`
   
      case $check1 in
         0)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin 1 night for night "$date2" last week (check1=$check1)"
              #./showplot -b --save-as-png $outfile
              if ! ./showplot -b --save-as-png $outfile >/dev/null
              then
                 printprocesslog "WARN showplot -b --save-as-png "$outfile" failed."
              fi
              ;;
         1)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin 1 night for night "$date2" last week, but nothing to plot (check1=$check1)"
              ;;
         *)   printprocesslog "ERROR lightcurve.C failed for source "$source" timebin 1 night for night "$date2" last week (check1=$check1)"
              ;;
      esac

      # doing the plots for all nights
      logfile=$outpath"/lightcurve"$source"_1night_all.log"
      outfile=$outpath"/lightcurve"$source"_1night_all.root"
      #echo $outfile
      printprocesslog "INFO starting lightcurve.C+ for source "$source" timebin 1 night for night "$date2" all nights"
   
      check1=`root -q -b fact/analysis/lightcurve.C+\($source\,$firstnight\\,$date2\,-1\,"\"$tablename"\"\,"\"$outfile\""\,kFALSE\) | tee $logfile | intgrep`
   
      case $check1 in
         0)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin 1 night for night "$date2" all nights (check1=$check1)"
              #./showplot -b --save-as-png $outfile
              if ! ./showplot -b --save-as-png $outfile >/dev/null
              then
                 printprocesslog "WARN showplot -b --save-as-png "$outfile" failed."
              fi
              ;;
         1)   printprocesslog "INFO lightcurve.C was successful for source "$source" timebin 1 night for night "$date2" all nights, but nothing to plot (check1=$check1)"
              ;;
         *)   printprocesslog "ERROR lightcurve.C failed for source "$source" timebin 1 night for night "$date2" all nights (check1=$check1)"
              ;;
      esac
      
   done
   printprocesslog "INFO rsync output of source "$source" to gate."
   #rsync -av $anapath/lightcurves/ gate:/home/factwww/lightcurves
   rsync -a $anapath/lightcurves/ gate:/home/factwww/lightcurves
done


finish

