#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

seqfile=$1
seqnum=`basename $seqfile | sed -e 's/[.]seq//g'`
#outpath=`dirname $seqfile | sed -e "s/sequences/${1}\/callisto/"`
outpath=`dirname $seqfile | sed -e "s/sequences/callisto/"`
makedir $outpath
logfile=$outpath"/"$seqnum"-calibration.log"

# make sure that no other RunCallisto.sh is started for this seq
touch $logfile

cd $mars

# check how many callistos are running
callistocount=`ps aux | grep callisto.C | grep -E -o '20[12][0-9][01][0-9][0-3][0-9]_[0-9][0-9][0-9]' | sort | uniq | wc -l`

while [ $callistocount -ge $numcallistos ]
do
   source `dirname $0`/../Sourcefile.sh
   printprocesslog "INFO wait "$callistowait" as "$callistocound" callistos running ( "$numcallistos" allowed). "
   sleep $callistowait
   callistocount=`ps aux | grep callisto.C | grep -E -o '20[12][0-9][01][0-9][0-3][0-9]_[0-9][0-9][0-9]' | sort | uniq | wc -l`
done

# run callisto 
printprocesslog "INFO starting callisto.C for sequence "$seqnum

check1=`root -q -b fact/analysis/callisto.C\("\"$seqfile\""\,"\"$outpath\""\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO callisto was successful for sequence "$seqnum" (check1=$check1)"
        `dirname $0`/RunStar.sh $seqfile &
        ;;
   *)   printprocesslog "ERROR callisto.C failed for sequence "$seqnum" (check1=$check1)"
        ;;
esac

finish 

