#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

logfile=$1

cd $mars

# run star 
printprocesslog "INFO starting star_file.C for file "$2

echo "root -q -b fact/analysis/star_file.C\("\"$2\""\,5.2\,3.3\,"\"$3\""\) | tee $logfile | intgrep"
check1=`root -q -b fact/analysis/star_file.C\("\"$2\""\,5.2\,3.3\,"\"$3\""\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO star was successful for file "$2" (check1=$check1)"
        # run merpp
        printprocesslog "INFO starting merpp.C for file "$4
        logfile=`echo $logfile | sed -e 's/images/merpp/g'`
        
        echo "root -q -b fact/analysis/merpp_file.C\("\"$4\""\) | tee $logfile | intgrep"
        check2=`root -q -b fact/analysis/merpp_file.C\("\"$4\""\) | tee $logfile | intgrep`
        
        case $check2 in
           0)   printprocesslog "INFO merpp was successful for file "$4" (check2=$check2)"
                ;;
           *)   printprocesslog "ERROR merpp_file.C failed for file "$4" -> check log "$logfile"  (check2=$check2)"
                # delete image file in this case to be sure that ganymed doesn't try to process it
                if ls $4 >/dev/null 2>&1
                then
                   rm -v $4
                fi
                ;;
        esac
        ;;
   *)   printprocesslog "ERROR star_file.C failed for file "$2" -> check log "$1" (check1=$check1)"
        if ls $4 >/dev/null 2>&1
        then
           rm -v $4
        fi
        ;;
esac

finish 

