#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

logfile=$2

# make sure that no other RunCallisto.sh is started for this run
touch $logfile

cd $mars

# check how many callistos are running
callistocount=`ps aux | grep callisto_ | grep -E -o '20[12][0-9][01][0-9][0-3][0-9]_[0-9][0-9][0-9]' | sort | uniq | wc -l`

while [ $callistocount -ge $numcallistos ]
do
   source `dirname $0`/../Sourcefile.sh
   printprocesslog "INFO wait "$callistowait" as "$callistocount" callistos running ( "$numcallistos" allowed). "
   sleep $callistowait
   callistocount=`ps aux | grep callisto_ | grep -E -o '20[12][0-9][01][0-9][0-3][0-9]_[0-9][0-9][0-9]' | sort | uniq | wc -l`
done

case $1 in
   drun) # process data run
         printprocesslog "DEBUG fact/analysis/callisto_data.C\("\"$3\""\,"\"$4\""\,"\"$5\""\,"\"\""\,"\"$6\""\) | tee $logfile "
         check1=`root -q -b fact/analysis/callisto_data.C\("\"$3\""\,"\"$4\""\,"\"$5\""\,"\"\""\,"\"$6\""\) | tee $logfile | intgrep`
         ;;
   prun) # process pedestal run
         # currently not done (s Step1.sh)
         printprocesslog "DEBUG fact/analysis/callisto_pedestal.C\("\"$3\""\,"\"$4\"","\"$5\""\) | tee $logfile "
         check1=`root -q -b fact/analysis/callisto_pedestal.C\("\"$3\""\,"\"$4\"","\"$5\""\) | tee $logfile | intgrep`
         ;;
   crun) # process light-pulser run
         # currently not done (s Step1.sh)
         printprocesslog "DEBUG fact/analysis/callisto_lightpulser.C\("\"$3\""\,"\"$4\""\,"\"$5\""\,"\"$6\""\) | tee $logfile "
         check1=`root -q -b fact/analysis/callisto_lightpulser.C\("\"$3\""\,"\"$4\""\,"\"$5\""\,"\"$6\""\) | tee $logfile | intgrep`
         ;;
   time) # do drs-calib
         printprocesslog "DEBUG fact/analysis/callisto_drstime.C\("\"$3\""\,"\"$4\"","\"$5\""\) | tee $logfile "
         check1=`root -q -b fact/analysis/callisto_drstime.C\("\"$3\""\,"\"$4\"","\"$5\""\) | tee $logfile | intgrep`
         ;;
   *)    # default
         printprocesslog "WARN wrong parameter given to script RunCallisto.sh :"$1
         ;;
esac

case $check1 in
   0)   printprocesslog "INFO callisto was successful for file "$3" (check1=$check1)"
        if [ "$1" == "drun" ]
        then
           printprocesslog "INFO start RunStar.sh for file "$7
           starfile=`echo $7 | sed -e 's/callisto/star/g' -e 's/_C/_I/'`
           starlog=`echo $starfile | sed -e 's/_I.root/-images.log/'`
           outpath=`dirname $starfile`
           makedir $outpath
           `dirname $0`/RunStar.sh $starlog $7 $outpath $starfile
        fi
        ;;
   *)   printprocesslog "ERROR callisto failed for file "$3" (check1=$check1)"
        # allow for reprocessing in case callisto fails once
        cplogfile=$logfile.cp
        if ! ls $cplogfile >/dev/null
        then
           mv $logfile $cplogfile
        fi
        ;;
esac

finish 

