#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

#root=/opt/root_svn/bin/thisroot.sh
#source $root

anapath=/loc_data/analysis
auxpath=/loc_data/aux

printprocesslog "INFO get list of calibrated files"

date="2014/05/24"
#calfiles=( `find $anapath -type f -name '*_C.root' 2>/dev/null | grep -v failed_stuff | sort` )
calfiles=( `find $anapath/callisto/$date -type f -name '*_C.root' 2>/dev/null | sort` )
if [ ${#calfiles[@]} -eq 0 ]
then
   printprocesslog "INFO no calibrated files available "
   finish
fi
#starfiles=( `find $anapath -type f -name '*_I.root' 2>/dev/null | grep -v failed_stuff | sort` )
starfiles=( `find $anapath/star/$date -type f -name '*_I.root' 2>/dev/null | sort` )
if [ ${#starfiles[@]} -eq 0 ]
then
   printprocesslog "INFO no star files available "
#   finish
fi

echo ${#calfiles[@]}" "${#starfiles[@]}
printprocesslog "INFO #cal-files:"${#calfiles[@]}" #star-files:"${#starfiles[@]}

if [ ${#starfiles[@]} -lt ${#calfiles[@]} ] 
then
   for calfile in ${calfiles[@]}
   do 
      starfile=`echo $calfile | sed -e 's/callisto/star/' -e 's/_C/_I/'`
      logfile=`echo $starfile | sed -e 's/_I.root/-images.log/'`
      if ! ls $starfile >/dev/null 2>&1
      then
         echo $starfile" is missing -> reprocess. "
         outpath=`dirname $starfile`
         makedir $outpath
         `dirname $0`/RunStar.sh $logfile $calfile $outpath $starfile &	
         if ! ls $starfile >/dev/null 2>&1
         then 
            echo "  failed: check log "`echo $starfile | sed -e 's/_I.root/-images.log/'`
            echo "          check calfile "$calfile
         fi
         echo ""
      fi
   done
fi


