#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

# get dates
if [ "$certaindate" != "" ]
then
   getdates $certaindate
else
   if [ "$1" = "" ]
   then 
      # get all night
      #getdates "all"
      # get last 6 nights if hour between 7 and 19h, else only current night
      getdates 6 7 19
   else
      getdates $1
   fi
fi



for date in ${dates[@]}
do 
   printprocesslog "INFO processing "$date
   #echo "INFO processing "$date
   night=`echo $date | sed -e 's/\///g'`
   
   numganymeds=0
   # getting all image files for this night
   printprocesslog "INFO get file list for night "$date
   files=( `find $anapath/star/$date -type f -name '*_I.root' 2>/dev/null | sort` )
   if [ ${#files[@]} -eq 0 ]
   then
      printprocesslog "INFO no image files available for night "$date
      continue
   fi

   for file in ${files[@]}
   do
      night=`basename $file | cut -d_ -f1`
      run=`basename $file | cut -d_ -f2`
      printprocesslog "INFO processing run "$run
      # process only if merpp-log is available to make sure that star-file is complete
      # at ISDC seq# != run# -> get seq#
      if echo $resulttable1 | grep ISDC >/dev/null 2>&1
      then 
         query="SELECT LPAD(fSequenceID, 3, 0) FROM RunInfo WHERE fNight="$night" AND fRunID="$run
         seq=`sendquery`
         merpplog=`dirname $file`"/"$night"_"$seq"-merpp.log"
      else 
         merpplog=`echo $file | sed -e 's/_I.root/-merpp.log/'`
      fi
      # check if merpp is finished
      stillrunning=`find $merpplog -mmin -1 2>/dev/null`
      if ! [ -e $merpplog ] || [ "$stillrunning" != "" ]
      then
         printprocesslog "INFO merpp still running - wait with file "$file
         continue
      fi
      # process only if ganymedlogfiles is not yet there
      logfile=`echo $file | sed -e 's/star/ganymed_run/' -e 's/_I[.]root/-ganymed[.]log/'`
      if ! ls $logfile >/dev/null 2>&1
      then
         printprocesslog "DEBUG `dirname $0`/RunGanymed.sh "$file 
         if [ "$qlasge" = "yes" ]
         then
            printprocesslog "$sgepath/qsub -b y -q fact_short -v AUTOMATIONSETUP=$AUTOMATIONSETUP -v starfile=$file -e bla.txt -o bla.txt `dirname $0`/RunGanymed.sh"
            $sgepath/qsub -b y -q fact_short -v AUTOMATIONSETUP=$AUTOMATIONSETUP -v starfile=$file -e bla.txt -o bla.txt `dirname $0`/RunGanymed.sh
         else
            printprocesslog " INFO `dirname $0`/RunGanymed.sh $file"
            `dirname $0`/RunGanymed.sh $file
            echo "ganymed for "$file
         fi
         numganymeds=`echo " $numganymeds + 1 " | bc -l`
      fi
   done
   printprocesslog "INFO found "$numganymeds" ganymeds."
done

finish

