#!/bin/bash


# choose path according to which time range you want to check
files=`find /fact/aux/2018/06/2* -type f -name '*log'`



echo ""
echo "finding all Torque warnings and calculate some statistics..."
echo "------------------------------------------------------------"
echo ""
for file in $files
do 
   numall=`grep -c Torque $file`
   numaz=`grep Torque $file | grep -c Az`
   numzd=`grep Torque $file | grep -c Zd`
   numreal=`grep Torque $file | grep -oE 'W>\ [0-9][0-9]:[0-9][0-9]' | uniq -c | wc -l`
   time=`grep Torque $file | grep -oE 'W>\ [0-9][0-9]:[0-9][0-9]' | uniq -c | head -1 | grep -oE '[0-9][0-9]:[0-9][0-9]'`
   times=`grep Torque $file | grep -oE 'W>\ [0-9][0-9]:[0-9][0-9]' | uniq -c | grep -oE '[0-9][0-9]:[0-9][0-9]'`
   echo `basename $file`": "`printf '%02d' $numall`" -> "`printf '%02d' $numreal`" "`printf '%02d' $numaz`" Az "`printf '%02d' $numzd`" Zd first@"$time" ("`echo $times | sed -e 's/\ /|/g'`")" | sed -e 's/\ 0/\ \ /g'
done



echo ""
echo "finding all PowerOn and calculate nightly statistics..."
echo "-------------------------------------------------------"
echo ""
for file in $files
do 
   num=`grep -c 'PowerOn' $file`
   echo $file": "$num
done



echo ""
echo "Finding all PowerOn and calculate hourly statistics..."
echo "------------------------------------------------------"
echo ""
for file in $files
do 
   #echo $file
   num=`grep -c 'PowerOn' $file`
   echo $file": "$num
   grep 'PowerOn' $file | grep -oE 'I> [0-9][0-9]' | uniq -c
done


