#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

files=`find /gpfs0/fact/processing/data.r19161/star/ -name '*_I.root'`

for file  in ${files[@]}
do 
   night=`basename $file | cut -d_ -f1`
   run=`basename $file | cut -d_ -f2`
   logfile=`echo $file | sed -e 's/star/ganymed_run/' -e 's/_I[.]root/-ganymed[.]log/'`
   if ! ls $logfile >/dev/null 2>&1
   then
      echo "INFO processing "$file
      printprocesslog "DEBUG `dirname $0 | sed -e 's/Tools/QuickLook/'`/RunGanymed.sh "$file 
      if [ "$qlasge" = "yes" ]
      then
         printprocesslog "$sgepath/qsub -b y -q fact_short -v AUTOMATIONSETUP=$AUTOMATIONSETUP -v starfile=$file -e bla.txt -o bla.txt `dirname $0 | sed -e 's/Tools/QuickLook/'`/RunGanymed.sh"
         $sgepath/qsub -b y -q fact_short -v AUTOMATIONSETUP=$AUTOMATIONSETUP -v starfile=$file -e bla.txt -o bla.txt `dirname $0 | sed -e 's/Tools/QuickLook/'`/RunGanymed.sh | grep -v 'has been submitted'
      else
         printprocesslog " INFO `dirname $0 | sed -e 's/Tools/QuickLook/'`/RunGanymed.sh $file"
         `dirname $0 | sed -e 's/Tools/QuickLook/'`/RunGanymed.sh $file
      fi
   fi
done

finish

