#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=RsyncRawToISDC
step=RawFileRsyncedISDC
pwfile=/home_nfs/isdc/fact_opr/rsync.pwd

set -C

logfile=$runlogpath"/RsyncRawToISDC-"$datetime".log"
date >> $logfile 2>&1

# check if script is already running
lockfile=$lockpath/lock-$program.txt
checklock 

# get todo list
gettodo 


for (( s=0 ; s < $num ; s++ ))
do
   night=${primaries[$s+$s]}
   runid=${primaries[$s+$s+1]}
   nightpath=`echo $night | cut -c 1-4`"/"`echo $night | cut -c 5-6`"/"`echo $night | cut -c 7-8`
   
   setstatus "start" 

   rawfilelp="/loc_data/zipraw/./"$nightpath"/"$night"_"`printf %03d $runid`".fits.gz"
   rawdirisdc="/scratch/from_lapalma/raw/"
   rawfileisdc=$rawdirisdc$nightpath"/"$night"_"`printf %03d $runid`".fits.gz"
   ingestlinkpath="/scratch/ingest_links/raw/"$nightpath
   makedir $ingestlinkpath >> $logfile 2>&1
   ingestlink=$ingestlinkpath"/"$night"_"`printf %03d $runid`".fits.gz"

   printprocesslog "INFO rsync rawfile "$rawfilelp" to ISDC "$rawdirisdc
   echo "INFO rsync rawfile "$rawfilelp" to ISDC "$rawdirisdc >> $logfile 2>&1
   #rsync -rltDvR --partial --stats --password-file=$pwfile factdata@161.72.93.131::$rawfilelp $rawdirisdc >> $logfile 2>&1
   rsync -rltDvR -T $rsynctempdir --partial --stats fact@161.72.93.131:$rawfilelp $rawdirisdc >> $logfile 2>&1
   check1=$?

   case $check1 in
      0)   printprocesslog "INFO rawfile "$rawfilelp" transferred successfully to ISDC."
           printprocesslog "INFO create link for "$rawfileisdc
           ln -sv $rawfileisdc $ingestlink >> $logfile 2>&1
           check2=$?
           case $check2 in
              0)   printprocesslog "INFO link for  "$rawfileisdc" created successfully."
                   ;;
              *)   printprocesslog "WARN link for "$rawfileisdc" could not be created."
                   check=$check2
                   ;;
           esac
           ;;
      *)   printprocesslog "WARN "$rawfilelp" could not be transferred to ISDC."
           check=$check1
           ;;
   esac
   

   setstatus "stop" 
done

finish 

