#!/bin/bash
#
# This script does a backup of the QLA results
# It can be used in different location
# 
# Be careful: do NOT use --delete as on daq callisto files are deleted
# 

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

set -C

# get paths depending on host
case $HOSTNAME in
        dc11) from="fact_opr@isdc-nx00.isdc.unige.ch:/gpfs/scratch/fact/qla/"
              to="/scratch/fact/qla"
              ;;
         daq) from="/loc_data/analysis/"
              to="/newdaq/analysis_bu"
              ;;
   isdc-dl00) from="fact@161.72.93.131:/daq/analysis/"
              to="/gpfs/scratch/fact/qla"
              ;;
           *) echo "no valid host "$HOSTNAME
              exit
              ;;
esac

logfile=$runlogpath"/BackupQLA-"$datetime".log"
date >> $logfile

rsync -av $from $to >> $logfile 2>&1

finish >> $logfile 2>&1

