#!/bin/bash

# this script has been written to run on La Palma on the machine data
#   i.e. paths are only working on this machine

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting "$0

logfile=$runlogpath"/RsyncAuxToWue-"$datetime".log"
date >> $logfile

# get last 3, 6 or 9 nights
dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` `date +%Y/%m/%d --date="-60hour"` \
        `date +%Y/%m/%d --date="-84hour"` `date +%Y/%m/%d --date="-108hour"` `date +%Y/%m/%d --date="-132hour"` \
        `date +%Y/%m/%d --date="-156hour"` `date +%Y/%m/%d --date="-180hour"` `date +%Y/%m/%d --date="-204hour"` \
        )

# do rsync for rawfiles of these dates
for date in ${dates[@]}
do 
   echo "" >> $logfile 2>&1
   # auxiliary data directories
   auxdirisdc=/scratch/from_lapalma/aux/./$date/ 
   auxdirwue=/fact/aux
   
   if ! [ -d $auxdirisdc ]
   then 
      printprocesslog "INFO "$auxdirisdc" not available." >> $logfile 2>&1
      continue
   fi
   printprocesslog "INFO processing files in "$auxdirisdc >> $logfile 2>&1
   echo `date`": processing files in "$auxdirisdc >> $logfile 2>&1
   
   #rsync from ISDC to Wue
   if ! rsync -rltDvR --stats -T $rsynctempdir $auxdirisdc operator@coma.astro.uni-wuerzburg.de:$auxdirwue >> $logfile 2>&1
   then
      printprocesslog "WARN problem rsyncing auxiliary data for "$date" from ISDC to Wue"
      echo `date`": problem rsyncing auxiliary data for "$date" from ISDC to Wue" >> $logfile 2>&1
      echo `date`": problem rsyncing auxiliary data for "$date" from ISDC to Wue"
   fi
done

