#!/bin/bash

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting "$0

logfile=$runlogpath"/RsyncAuxToISDC-"$datetime".log"
date >> $logfile

# get dates
if [ "$certaindate" != "" ]
then
   getdates $certaindate
else
   # get all night
   #getdates "all"
   # get last 9 nights
   getdates 9
fi



# do rsync for rawfiles of these dates
for date in ${dates[@]}
do 
   echo "" >> $logfile 2>&1
   echo $date >> $logfile 2>&1
   # auxiliary data directories
   auxdirlp=/data2/aux/./$date/ 
   auxdirisdc=/scratch/from_lapalma/aux
   
   printprocesslog "INFO processing files in "$auxdirlp >> $logfile 2>&1
   echo `date`": processing files in "$auxdirlp >> $logfile 2>&1
   
   # get current hour
   hour=`date +%k`
   # define bwlimit for rsync depending on the time: from 19-7h reduced bwlimit for rsync
   if [ $hour -le 14 ] || [ $hour -ge 13 ]
   then
      # use once a day the -c option
      #   normally files are compared by size and time
      #   but for the daily files the size doesn't change when TSTOP is added
      #   due to the one hour time difference it could happen that rsync
      #     doesn't update the file when only checking time and size
      # run with this option after lunch (LP time)
      option="-c"
      printprocesslog "INFO rsync data with option "$option >> $logfile 2>&1
      echo "rsync data with option "$option >> $logfile 2>&1
   else 
      # no extra option
      printprocesslog "INFO rsync data without extra option" >> $logfile 2>&1
      echo "rsync data without extra option" >> $logfile 2>&1
   fi
   
   if ! ssh fact@161.72.93.138 "ls $auxdirlp >/dev/null 2>&1"
   then
      printprocesslog "INFO "$auxdirlp" not available on data. "
      continue
   fi
   
   #rsync from daq to data
   #if ! /usr/bin/rsync -avxHPu $bwlimit $auxdirdaq $auxdirdata >> $logfile 2>&1 # in case of adding checksum, only update files with rsync
   if ! rsync -rltDvR -T $rsynctempdir --stats fact@161.72.93.138:$auxdirlp $auxdirisdc >> $logfile 2>&1
   then
      printprocesslog "CONNECTION problem rsyncing auxiliary data for "$date" from La Palma to ISDC"
      echo `date`": problem rsyncing auxiliary data for "$date" from La Palma to ISDC" >> $logfile 2>&1
   fi
done

