#!/bin/bash

year=`date +%Y --date="-1day"`
month=`date +%m --date="-1day"`

auxdir=loc_data/aux/$year/$month
echo `date`": processing files in "$auxdir

today=`date +%F`
logfile=/home/`whoami`/DataCheck/log/RsyncAux$today.log

#rsync from daq to data
if ! /usr/bin/rsync -avxH 10.0.100.12::$auxdir /$auxdir >> $logfile 2>&1
then
   echo `date`": problem rsyncing auxiliary data from daq to data"
fi


