#!/bin/bash

year=`date +%Y --date="-1day"`
month=`date +%m --date="-1day"`

rawdir=loc_data/raw/$year/$month
echo `date`": processing files in "$rawdir

today=`date +%F`
logfile=/home/`whoami`/DataCheck/log/RsyncRaw$today.log

#rsync from daq to data
if ! /usr/bin/rsync -avxH 10.0.100.12::$rawdir /$rawdir >> $logfile 2>&1
then
   echo `date`": problem rsyncing rawdata from daq to data"
fi


