#!/bin/bash

dir=/loc_data
if [ "$HOSTNAME" == "daq" ]
then
   dir=/raid10
fi

# get current hour
hour=`date +%k`
# define bwlimit for rsync depending on the time
if [ $hour -lt 10 ] || [ $hour -gt 18 ]
then
   # check 200 GB
   dulimit=209715200
   dutext="200 GB"
else
   # check 500 GB
   dulimit=524288000
   dutext="500 GB"
fi

# get available disk space
diskusage=( `df -P $dir | grep $dir ` )
# check if more than X GB are left on /loc_data
if [ ${diskusage[3]} -lt $dulimit ] 
then
   echo "WARN less than "$dutext" left on /loc_data on node "$HOSTNAME
   df -h $dir
fi

