#!/bin/bash

today=`date +%F`
logfile=/home/`whoami`/DataCheck/log/RsyncAux$today.log

echo "" >> $logfile 2>&1
echo "" >> $logfile 2>&1
echo "" >> $logfile 2>&1

# check if /daq is mounted on data
if ! mount | grep daq >> $logfile 2>&1
then 
   echo "/daq is not mounted on data => please mount it"
   exit
fi

# get last 3 nights
dates=( `date +%Y/%m/%d` `date +%Y/%m/%d --date="-1day"` `date +%Y/%m/%d --date="-2day"` `date +%Y/%m/%d --date="-3day"` )

# do rsync for rawfiles of these dates
for date in ${dates[@]}
do 
   echo "" >> $logfile 2>&1
   # auxiliary data directories on data 
   auxdirdaq=/daq/aux/$date/ # /loc_data from daq via nfs on data
   if ! [ -d $auxdirdaq ]
   then 
      echo `date`": "$auxdirdaq" not found. Data were probably taken on data" >> $logfile 2>&1
      continue
   fi
   auxdirdata=/loc_data/aux/$date 
   if ! [ -d $auxdirdata ]
   then 
      mkdir -pv $auxdirdata >> $logfile 2>&1
   fi
   echo `date`": processing files in "$auxdirdaq >> $logfile 2>&1
   
   # get current hour
   hour=`date +%k`
   # define bwlimit for rsync depending on the time
   if [ $hour -lt 8 ] || [ $hour -gt 18 ]
   then
      # limit bw for rsync to 20 MB/s during night
      bwlimit="--bwlimit=20000"
      echo "rsync data with "$bwlimit >> $logfile 2>&1
   else 
      # no bw limit during day
      echo "rsync data without bwlimit" >> $logfile 2>&1
   fi
   
   #rsync from daq to data
   if ! /usr/bin/rsync -avxHP $bwlimit $auxdirdaq $auxdirdata >> $logfile 2>&1
   then
      echo `date`": problem rsyncing auxiliary data for "$date" from daq to data"
   fi
done

