#!/bin/bash

sourceFolder=$1 
destFolder=$2 

if [ "$#" != "2" ]
then
	echo "Please specify source and dest folders. Aborting"
	exit
fi

if [ $1 == "" ]
then
	echo "Source folder is empty. Aborting"
	exit
fi

if [ $2 == "" ]
then
	echo "Dest folder is empty. Aborting"
	exit
fi

#first let's make sure that source and dest folders do exist, and that dest is writable
if [ -d $1 ]
then
	sourceFolder=$1
else
	echo "Source folder "$1" does not exist (or cannnot be read.) Aborting"
	exit
fi

if [ -d $2 ]
then
	if [ -d $2"/etiennetest" ]
	then
		echo "Test folder already exist. Aborting"
		exit
	fi
	mkdir $2"/etiennetest" 2>/dev/null
	if [ -d $2"/etiennetest" ]
	then
		rm -rf $2"/etiennetest"
		destFolder=$2
	else
		echo "Dest folder is not writable. Aborting"
		exit
	fi
else
	echo "Dest folder does not exist. Aborting"
	exit
fi

#files=`ls $destFolder`
#if [ "$files" != "" ]
#then
#	echo "Dest folder is not empty. Aborting"
#	exit
#fi
sourceFolder=${sourceFolder%/}
destFolder=${destFolder%/}
echo "Will start ingesting files from "$sourceFolder" to "$destFolder

#list all the files in sourceFolder, and copy then with the same structure to destfolder

entries=`find $sourceFolder -type f -name '*.fits' | sort`

for entry in ${entries[@]}
do
	#first construct the correct file name
	targetFileName=`correctFileName $entry`
       #second construct the destination path.
	filenameonly=${entry##*/}
	pathonly=${entry%$filenameonly}
	extrapathonly=${pathonly#$sourceFolder/}
	targetFolder=$destFolder"/"$extrapathonly
	if [ ! -d $targetFolder ]
	then
		mkdir -p $targetFolder
	fi
	
	#check if the file already exist there
	targetFile=$targetFolder"/"$targetFileName
	echo "$targetFile"
	if [ -a $targetFile ]
	then
		echo "File $targetFile already exist. Skipping it" >> report.txt
		continue
	fi
	cp $entry $targetFile
	#if not, do the copying, fixing and checking

#	grouping=`/home/isdc/lyard/FACT++/fitsdump $targetFile -h 2>/dev/null | grep GROUPING`
	
#	grouping=`grep 'GROUPING' "temp.txt"`
		
#	if [ "$grouping" == "" ]
#	then
		
	repairAuxFile.sh $targetFile ENDerrors.txt MJDerror.txt report.txt processErrors.txt
	
	if [ -a $targetFile ]
	then
		fixAuxKeyWords.sh $targetFile reportTwo.txt processErrors.txt
		result=`fverify $targetFile 2>/dev/null | grep '0 error(s)'`
		if [ "$result" == "" ]
		then
			echo "$targetFile" >> stillHasProblems.txt
			rm $targetFile
		fi
	fi
done

#set the correct permissions
find $destFolder -type f -exec chmod 640 {} \;
find $destFolder -type d -exec chmod 750 {} \;
find $destFolder -exec chgrp fact {} \;






















