#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=BuildSequences

set -C

# check if script is already running
lockfile=$lockpath/lock-$program.txt
checklock 

logfile=$runlogpath"/BuildSequences-"$datetime".log"
date >> $logfile

cd $mars

check1=`root -q -b datacenter/macros/buildseqentriesf.C+\("\"$datapath\""\,"\"$seqpath\""\,1\,kFALSE\) | tee $logfile | intgrep`

case $check1 in
   1)   printprocesslog "INFO built sequences was successfully (check1=$check1)"
        ;;
   0)   printprocesslog "WARN connection to DB failed (check1=$check1)"
        #check="no"
        ;;
   *)   printprocesslog "ERROR buildseqentriesf.C failed (check1=$check1)"
        #check=$check1
        ;;
esac

finish 

