#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=CheckRawFilesAvail
step=RawFileAvailISDC
transferdelay=3 #days

set -C

# check if script is already running
lockfile=$lockpath/lock-$program.txt
checklock 

# get todo list
gettodo 


for (( s=0 ; s < $num ; s++ ))
do
   night=${primaries[$s+$s]}
   runid=${primaries[$s+$s+1]}
   currentnight=`date +%Y%m%d`
   checknight=`echo " $currentnight - $transferdelay " | bc -l`
   
   setstatus "start" 

   rawfile=$rawdata/`echo $night | cut -c 1-4`/`echo $night | cut -c 5-6`/`echo $night | cut -c 7-8`/$night"_"`printf %03d $runid`".fits.gz"
   test -e $rawfile 
   check1=$?

   case $check1 in
      0)   printprocesslog "INFO found rawfile "$rawfile
           ;;
      *)   # print warning only for files which are older than $transferdelay days
           if [ $night -lt $checknight ]
           then 
              printprocesslog "WARN "$rawfile" missing."
           else
              printprocesslog "INFO "$rawfile" missing."
           fi
           check="no"
           ;;
   esac

   setstatus "stop" 
done

finish 

