#!/bin/bash
#
# Script to check whether disk is full
#

# possible limits
limits=( 209715200 524288000 1073741824 2147483648 )
texts=(   "200 GB"  "500 GB"     "1 TB"     "2 TB" )

# set standard limits
lowlimit=1
highlimit=2

# get paths depending on host
case $HOSTNAME in
        data) dirs=( "/loc_data" "/daq" )
              ;;
         daq) dirs=( "/raid10" )
              ;;
   isdc-dl00) dirs=( "/fact" "/scratch" )
              highlimit=3
              ;;
           *) echo "no valid host "$HOSTNAME
              exit
              ;;
esac

# get current hour
hour=`date +%k`

# define disk space limit for check depending on the time
if [ $hour -lt 8 ] || [ $hour -gt 15 ]
then
   # during night
   dulimit=${limits[$lowlimit]}
   dutext=${texts[$lowlimit]}
else
   # during day
   dulimit=${limits[$highlimit]}
   dutext=${texts[$highlimit]}
fi

for dir in ${dirs[@]}
do 
   # get available disk space
   diskusage=( `df -P $dir | grep $dir ` )
   # check if more than X GB are left on /loc_data
   if [ ${diskusage[3]} -lt $dulimit ] 
   then
      echo "WARN less than "$dutext" left on "$dir" on node "$HOSTNAME
      df -h $dir
      echo ""
   fi
done

