#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=RunCallisto
step=Callisto

set -C

for (( i=0; i<100; i++ ))
do 
   # get todo list
   gettodo "1"

   # get all needed variables
   night=${primaries[0]}
   seqid=${primaries[1]}
   nightpath=`echo $night | cut -c 1-4`"/"`echo $night | cut -c 5-6`"/"`echo $night | cut -c 7-8`
   seqnum=$night"_"`printf %03d $seqid`

   # check if script is already running
   lockfile=$lockpath"/lock-"$program"-"$seqnum".txt"
   checklock continue
   printprocesslog "INFO got todo with try #"$i
   break
done

# get all needed paths and files
seqfile=$seqpath"/"$nightpath"/"$seqnum".seq"
outpath=$datapath"/callisto/"$nightpath
makedir $outpath
logfile=$outpath"/"$seqnum"-calibration.log"

cd $mars

# run callisto 
printprocesslog "INFO starting callisto5.C for sequence "$seqnum
setstatus "start" 

check1=`root -q -b fact/callisto5.C\("\"$seqfile\""\,"\"$outpath\""\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO callisto was successful for sequence "$seqnum" (check1=$check1)"
        ;;
   *)   printprocesslog "ERROR callisto5.C failed for sequence "$seqnum" (check1=$check1)"
        check=$check1
        ;;
esac

setstatus "stop" 

finish 

