#!/bin/bash

# option 
doupdate="yes" # update all entries (needed when new fields have been added)
doupdate="no" # fill only entries which are not yet existing (default)

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 with option doupdate="$doupdate

#logfile=$runlogpath"/FillMoonInfo-"$datetime".log"
#date >> $logfile

# get last 3, 6 or 9 nights
dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` `date +%Y/%m/%d --date="-60hour"` \
#        `date +%Y/%m/%d --date="-84hour"` `date +%Y/%m/%d --date="-108hour"` `date +%Y/%m/%d --date="-132hour"` \
#        `date +%Y/%m/%d --date="-156hour"` `date +%Y/%m/%d --date="-180hour"` `date +%Y/%m/%d --date="-204hour"` \
        )
#dates=( `find $auxdata -mindepth 3 -type d | sort -r | sed "s/\${auxdata_for_sed}//g" | sed -e 's/^\///'` )

printprocesslog "INFO processing the following night(s): "${dates[@]}
#echo  `date`": processing the following night(s): "${dates[@]} #>> $logfile 2>&1

# do filling of aux data 
for date in ${dates[@]}
do 
   runnumber=`echo $date | sed -e 's/\///g'`
   if [ $runnumber -lt 20111115 ]
   then
      continue
   fi
   printprocesslog "INFO processing date "$date
   #echo "INFO processing date "$date

   # get file numbers from DB
   #   but only for not-corrupted files
   #query="SELECT fRunID from RunInfo WHERE fNight="$runnumber" AND NOT ISNULL(fRightAscension) AND NOT ISNULL(fDeclination) "
   query="SELECT fRunID from RunInfo WHERE fNight="$runnumber" AND NOT ISNULL(fRunStart) "
   #query=$query" AND fRunTypeKEY=6 "
   if [ "$doupdate" = "no" ]
   then
      query=$query" AND ISNULL(fMoonDisk) "
   fi
   printprocesslog "DEBUG get filenumbers from DB: QUERY: "$query
   filenumbers=( `sendquery` )
   if [ ${#filenumbers} -eq 0 ]
   then
      printprocesslog "INFO No files found in the DB for night "$date
      continue
   fi

   # fill auxiliary information for files
   for filenum in ${filenumbers[@]}
   do
      printprocesslog "INFO processing file number "$runnumber"_"`printf %03d $filenum`
      #echo  `date`": processing file number "$runnumber"_"`printf %03d $filenum` # >> $logfile 2>&1
      
      # get input info from DB 
      #  query 999 in case value is empty to easily recognize this case
      query="SELECT if (isnull(fRightAscension), 999, fRightAscension), "
      query=$query" if (isnull(fDeclination), 999, fDeclination), "
      query=$query" fRunStart from RunInfo "
      query=$query" WHERE fNight="$runnumber" AND fRunID="$filenum
      info=( `sendquery` )
      #echo ${info[@]}
      #echo "/home/fact/FACT++.db/moon "${info[2]} ${info[3]}" --ra=${info[0]} --dec=${info[1]} 2>/dev/null"
      if [ "${info[0]}" == "999" ] && [ "${info[1]}" == "999" ]
      then 
         lightinfo=( `/home/fact/FACT++.upgrade/moon "${info[2]} ${info[3]}" 2>/dev/null` )
      else
         lightinfo=( `/home/fact/FACT++.upgrade/moon "${info[2]} ${info[3]}" --ra=${info[0]} --dec=${info[1]} 2>/dev/null` )
      fi
      # return values of the programm
      # timestamp sunzd moon-visible moondisk moonzd angletomoon angletosun
      #echo ${lightinfo[@]}
      
      # build query to update runinfo in DB
      query="UPDATE RunInfo SET fSunZenithDistance="${lightinfo[2]}", fMoonDisk="${lightinfo[4]}
      query=$query", fMoonZenithDistance="${lightinfo[5]}
      if [ "${info[0]}" != "999" ] && [ "${info[1]}" != "999" ]
      then 
         query=$query", fAngleToMoon="${lightinfo[6]}
         query=$query", fAngleToSun="${lightinfo[7]}
      fi
      # add where condition
      query=$query" WHERE fNight="$runnumber" AND fRunID="$filenum
      #echo $query
      # send query to DB
      sendquery >/dev/null
   done
done

finish


