#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

seqfile=$2
seqnum=`basename $seqfile | sed -e 's/[.]seq//g'`
inpath=`dirname $seqfile | sed -e "s/sequences/${1}\/callisto/"`
outpath=`dirname $seqfile | sed -e "s/sequences/${1}\/star/"`
makedir $outpath
logfile=$outpath"/"$seqnum"-images.log"

cd $mars

# run star 
printprocesslog "INFO starting star.C for sequence "$seqnum

check1=`root -q -b fact/star.C\("\"$seqfile\""\,4.0\,2.5\,"\"$inpath\""\,"\"$outpath\""\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO star was successful for sequence "$seqnum" (check1=$check1)"
        # run merpp
        printprocesslog "INFO starting merpp3.C for sequence "$seqnum
        logfile=$outpath"/"$seqnum"-merpp.log"
        
        check1=`root -q -b fact/merpp3.C\("\"$seqfile\""\,"\"$outpath\""\) | tee $logfile | intgrep`
        
        case $check1 in
           0)   printprocesslog "INFO merpp was successful for sequence "$seqnum" (check1=$check1)"
                ;;
           *)   printprocesslog "ERROR merpp3.C failed for sequence "$seqnum" (check1=$check1)"
                # delete image file in this case to be sure that ganymed doesn't try to process it
                imgfile=$outpath"/"$seqnum"_I.root"
                if ls $imgfile >/dev/null 2>&1
                then
                   rm -v $imagefile
                fi
                ;;
        esac
        ;;
   *)   printprocesslog "ERROR star.C failed for sequence "$seqnum" (check1=$check1)"
        ;;
esac

finish 

