#!/bin/bash
#
# script to read observation information from the database
# format: as given by David
# MJD DATE START STOP FLUX COMMENT
# for times before midnight: eg 22:33 -> -01:27


source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 $1"

# getting db info for query
getdbsetup

function get_table()
{
   printprocesslog "INFO writing "$file
   query="SELECT Datediff(Max(fRunStop), '1858-11-17') as MJD, "
   query=$query" Date_format(Max(fRunStop), '%Y/%m/%d') as DATE, "
   #query=$query" Date_format(Min(fRunStart), '%H:%i') as STARTOLD, "
   query=$query" if(Hour(Min(fRunStart))>10, Concat('-', Time_format(Addtime(Timediff(Concat(STR_TO_DATE(fNight, '%Y%m%d'), ' 23:59:59'), Min(fRunStart)), '0 0:1:0.0'), '%H:%i')), Date_format(Min(fRunStart), '%H:%i')) as START, "
   #query=$query" Date_format(Max(fRunStop), '%H:%i') as STOPOLD, "
   query=$query" if(Hour(Max(fRunStop))>10, Concat('-', Time_format(Addtime(Timediff(Concat(STR_TO_DATE(fNight, '%Y%m%d'), ' 23:59:59'), Max(fRunStop)), '0 0:1:0.0'), '%H:%i')), Date_format(Max(fRunStop), '%H:%i')) as STOP, "
   query=$query" CONCAT('---') as FLUX, "
   #query=$query" CONCAT('#') as Comments"
   #query=$query" CONCAT('# ', Timediff(Max(fRunStop), Min(fRunStart)), ' ontime: ', Convert(Sum(Time_to_sec(Timediff(fRunStop, fRunStart)))/60./60., decimal(2,1))) AS Comments"
   query=$query" CONCAT('# ontime: ', Convert(Sum(fOntime)/3600, decimal(2,1)), 'h') AS Comments"
   query=$query" FROM RunInfo "
   query=$query" WHERE fSourceKEY="$sourcekey
   query=$query" AND fRunTypeKEY=1 "
   query=$query" AND fNight BETWEEN "$start" AND "$stop
   query=$query" GROUP BY fNight "
   query=$query" ORDER BY fNight "
   #echo $query
   #echo ""
   printprocesslog "DEBUG sendquery QUERY: "$query
   # sendquery can't be used as it writes everything into a variable
   mysql -s -u $us --password=$pw --host=$ho $db -e " $query " > $file
}


#mrk421
sourcekey=1

file="Mrk421_FACT_observations_all.txt"
start=20111115
stop=20200101
get_table

file="Mrk421_FACT_observations_2011_2012.txt"
start=20120101
stop=20120701
get_table

file="Mrk421_FACT_observations_2012_2013.txt"
start=20121001
stop=20130930
get_table


#mrk501
sourcekey=2

file="Mrk501_FACT_observations_all.txt"
start=20120501 #really started at 19.5.2012
stop=20200101
get_table

file="Mrk501_FACT_observations_2011_2012.txt"
start=20120501 #really started at 19.5.2012
stop=20121030
get_table

file="Mrk501_FACT_observations_2012_2013.txt"
start=20130101 
stop=20131030
get_table

