#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 $1"

#root=/opt/root_svn/bin/thisroot.sh
#source $root
#factpath=/home/fact/FACT++.in-run-fad-loss
export LD_LIBRARY_PATH=./:$LD_LIBRARY_PATH

cd $mars

if ! [ "$1" = "min" ] && ! [ "$1" = "nights" ]
then 
   echo "wrong option "$1" (only min and nights valid)."
   finish
fi

if [ "$1" = "min" ]
then 
   date=`date --date="-18HOUR" +%Y/%m/%d`
fi

#anapath=/loc_data/analysis

# source info on daq in /loc_data/analysis/sources.txt 
#    (dump of DB scheduling.sources)
sources=( 1 2 5 7 11 )

for source in ${sources[@]}
do 
   dirs=( `find $anapath/$source/ganymed*$1 -maxdepth 0 -type d 2>/dev/null` )
   if [ ${#dirs[@]} -eq 0 ]
   then
      printprocesslog "INFO no directories ("$1") found for source "$source
      continue
   fi
   for dir in ${dirs[@]}
   do 
      printprocesslog "INFO processing files in "$dir
      inpath=$dir
      outpath=`echo $dir | sed -e 's/ganymed/lightcurve/'`
      logfile=$outpath/lightcurve.log
      makedir $outpath
      printprocesslog "INFO starting lightcurve.C+ for path "$inpath
      
      check1=`root -q -b $anapath/lightcurve.C+\("\"$inpath\""\,"\"$outpath\"","\"$date\""\) | tee $logfile | intgrep`
      
      case $check1 in
         0)   printprocesslog "INFO lightcurve.C was successful for path "$inpath" (check1=$check1)"
              ./showplot -b --save-as-png $outpath/lc.root
              ;;
         *)   printprocesslog "ERROR lightcurve.C failed for dataset "$inpath" (check1=$check1)"
              ;;
      esac
   done
   printprocesslog "INFO rsync output of source "$source" to gate."
   rsync -av $anapath/$source/lightcurve* gate:/home/factwww/lightcurves/$source/
done


finish

