#!/bin/bash

month=$1

if [ "$month" == "" ]
then
	echo "Please give the month to look for as parameter"
	exit
fi

archive="/archive/fact/rev_1/raw/2011/"$month
tempFile="tempFile$month.txt"
tempFile2="tempFile2$month.txt"
entries=`find $archive -type f -name '*.fits.gz' | sort`

for entry in ${entries[@]}
do
	res=`echo $entry | grep 'drs'`
	if [ "$res" != "" ]
	then
		continue
	fi
	if [ -f $tempFile ]
	then
		rm $tempFile
	fi
	if [ -f $tempFile2 ]
	then
		rm $tempFile2
	fi
	
	tstartf=1
	tstartf2=2
	
	result=`/opt/FACT++/fitsdump -h $entry > $tempFile`
	origEntry=`echo $entry | sed -e 's/archive\/fact\/rev_1/data00\/fact-construction/g'`
	if [ ! -f $origEntry ]
	then
		echo $entry >> headerReportRaw_$month.txt
		echo "Name was changed" >> headerReportRaw_$month.txt
		continue
	fi
	result2=`/opt/FACT++/fitsdump -h $origEntry > $tempFile2`
	
	tstartf=`grep 'TSTARTF' $tempFile | grep -E -o '0\.[0-9]{7}' `
	tstartf2=`grep 'TSTARTF' $tempFile2 | grep -E -o '0\.[0-9]{7}' `
	if [ "$tstartf" == "" ]
	then
		tstartf=`grep 'TSTARTF' $tempFile | grep -E -o '0'`
	fi
	if [ "$tstartf2" == "" ]
	then
		tstartf2=`grep 'TSTARTF' $tempFile2 | grep -E -o '0'`
	fi

	tstarti=`grep 'TSTARTI' $tempFile | grep -E -o '[0-9]{5}' `
	tstarti2=`grep 'TSTARTI' $tempFile2 | grep -E -o '[0-9]{5}' `
	tstopf=`grep 'TSTOPF' $tempFile | grep -E -o '0\.[0-9]{7}'`
	tstopf2=`grep 'TSTOPF' $tempFile2 | grep -E -o '0\.[0-9]{7}'`
	if [ "$tstopf" == "" ]
	then
		tstopf=`grep 'TSTOPF' $tempFile | grep -E -o '0'`
	fi
	if [ "$tstopf2" == "" ]
	then
		tstopf2=`grep 'TSTOPF' $tempFile2 | grep -E -o '0'`	
	fi
	tstopi=`grep 'TSTOPI' $tempFile | grep -E -o '[0-9]{5}'`
	tstopi2=`grep 'TSTOPI' $tempFile2 | grep -E -o '[0-9]{5}'`
	dateobs=`grep 'DATE-OBS' $tempFile | grep -E -o 201[1-3]-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]{4}`
	dateobs2=`grep 'DATE-OBS' $tempFile2 | grep -E -o 201[1-3]-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]{4}`
	dateend=`grep 'DATE-END' $tempFile | grep -E -o 201[1-3]-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]{4} `
	dateend2=`grep 'DATE-END' $tempFile2 | grep -E -o 201[1-3]-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]{4}` 
	telescop=`grep 'TELESCOP' $tempFile`
	telescop2=`grep 'TELESCOP' $tempFile2`
	package=`grep 'PACKAGE' $tempFile`
	package2=`grep 'PACKAGE' $tempFile2`
	origin=`grep 'ORIGIN' $tempFile`
	origin2=`grep 'ORIGIN' $tempFile2`
	timeunit=`grep 'TIMEUNIT' $tempFile`
	timeunit2=`grep 'TIMEUNIT' $tempFile2`
	mjdref=`grep -E '## +MJDREF' $tempFile`
	mjdref2=`grep -E '## +MJDREF' $tempFile2`
	timesys=`grep 'TIMESYS' $tempFile`
	timesys2=`grep 'TIMESYS' $tempFile2`
	
	echo $entry >> headerReportRaw_$month.txt
	echo $entry
	
	if [ "$tstarti" != "$tstarti2" ]
	then
		echo "TSTARTI. new: "$tstarti" old: "$tstarti2 >> headerReportRaw_$month.txt
	fi
	if [ "$tstartf" != "$tstartf2" ]
	then
		echo "TSTARTF. new: "$tstartf" old: "$tstartf2 >> headerReportRaw_$month.txt
	fi
	if [ "$tstopi" != "$tstopi2" ]
	then
		echo "TSTOPI. new: "$tstopi" old: "$tstopi2 >> headerReportRaw_$month.txt
	fi
	if [ "$tstopf" != "$tstopf2" ]
	then
		echo "TSTOPF. new: "$tstopf" old: "$tstopf2 >> headerReportRaw_$month.txt
	fi
	if [ "$dateobs" != "$dateobs2" ]
	then
		echo "DATEOBS. new: "$dateobs" old: "$dateobs2 >> headerReportRaw_$month.txt
	fi
	if [ "$dateend" != "$dateend2" ]
	then
		echo "DATEEND. new: "$dateend" old: "$dateend2 >> headerReportRaw_$month.txt
	fi
	if [ "$telescop" != "$telescop2" ]
	then
		echo "TELESCOP. new: "$telescop" old: "$telescop2 >> headerReportRaw_$month.txt
	fi
	if [ "$package" != "$package2" ]
	then
		echo "PACKAGE. new: "$package" old: "$package2 >> headerReportRaw_$month.txt
	fi
	if [ "$origin" != "$origin2" ]
	then
		echo "ORIGIN. new: "$origin" old: "$origin2 >> headerReportRaw_$month.txt
	fi
	if [ "$timeunit" != "$timeunit2" ]
	then
		echo "TIMEUNIT. new: "$timeunit" old: "$timeunit2 >> headerReportRaw_$month.txt
	fi
	if [ "$mjdref" != "$mjdref2" ]
	then
		echo "MJDREF. new: "$mjdref" old: "$mjdref2 >> headerReportRaw_$month.txt
	fi
	if [ "$timesys" != "$timesys2" ]
	then
		echo "TIMESYS. new: "$timesys" old: "$timesys2 >> headerReportRaw_$month.txt
	fi
done

