#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

source=$1
dsfile=$2
path=$anapath/$source

outpath=`dirname $dsfile | sed -e 's/datasets/ganymed/'`
makedir $outpath

dsnum=`basename $dsfile | sed -e 's/dataset//' -e 's/[.]txt//'`
output=$outpath/$dsnum
logfile=$output"-ganymed.log"

cd $mars

# run ganymed 
printprocesslog "INFO starting ganymed.C for dataset "$dsfile

check1=`root -q -b $path/ganymed.C\("\"$dsfile\""\,"\"$output\""\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO ganymed was successful for dataset "$dsfile" (check1=$check1)"
        ;;
   *)   printprocesslog "ERROR ganymed.C failed for dataset "$dsfile" (check1=$check1)"
        ;;
esac

finish 

