#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

seqfile=$2
seqnum=`basename $seqfile | sed -e 's/[.]seq//g'`
outpath=`dirname $seqfile | sed -e "s/sequences/${1}\/callisto/"`
makedir $outpath
logfile=$outpath"/"$seqnum"-calibration.log"

cd $mars

# run callisto 
printprocesslog "INFO starting callisto6.C for sequence "$seqnum

check1=`root -q -b fact/callisto6.C\("\"$seqfile\""\,"\"$outpath\""\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO callisto was successful for sequence "$seqnum" (check1=$check1)"
        `dirname $0`/RunStar.sh $1 $seqfile &
        ;;
   *)   printprocesslog "ERROR callisto6.C failed for sequence "$seqnum" (check1=$check1)"
        ;;
esac

finish 

