#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

dsfile=$1
ra=$2
dec=$3

outpath=`dirname $dsfile | sed -e 's/datasets/ganymed/'`
makedir $outpath

dsnum=`basename $dsfile | sed -e 's/dataset//' -e 's/[.]txt//'`
output=$outpath/$dsnum
logfile=$output"-ganymed.log"

mars=/home/fact/Mars
cd $mars
# use macro from different mars version until versions are sorted out
mars2=/home/fact/SW.automatic.processing/Mars.svn.2013.04.12


# run ganymed 
printprocesslog "INFO starting ganymed.C for dataset "$dsfile
#echo "INFO starting ganymed.C for dataset "$dsfile

check1=`root -q -b $mars2/fact/analysis/ganymed.C\("\"$dsfile\""\,"\"$output\""\,$ra\,$dec\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO ganymed was successful for dataset "$dsfile" ra "$ra" dec "$dec" (check1=$check1)"
        ;;
   *)   printprocesslog "ERROR ganymed.C failed for dataset "$dsfile" ra "$ra" dec "$dec" (check1=$check1)"
        ;;
esac

finish 

