#!/bin/bash

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting "$0

logfile=$runlogpath"/FillNumEvts-"$datetime".log"
date >> $logfile

# get current hour
hour=`date +%k`
if [ $hour -le 7 ] || [ $hour -ge 19 ]
then
   dates=( `date +%Y/%m/%d --date="-12hour"` )
else
   # get last 3, 6 or 9 nights
   dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` `date +%Y/%m/%d --date="-60hour"` \
   #        `date +%Y/%m/%d --date="-84hour"` `date +%Y/%m/%d --date="-108hour"` `date +%Y/%m/%d --date="-132hour"` \
   #        `date +%Y/%m/%d --date="-156hour"` `date +%Y/%m/%d --date="-180hour"` `date +%Y/%m/%d --date="-204hour"` \
           )
fi

#dates=( `find -L $auxdata -mindepth 3 -type d | sort -r | grep -v bad | sed "s/\${auxdata_for_sed}//g" | sed -e 's/^\///'` ) #all available dates in /loc_data/zipraw

#dates=( "2013/04/17" )

printprocesslog "INFO processing the following night(s): "${dates[@]}
echo  `date`": processing the following night(s): "${dates[@]} >> $logfile 2>&1

#echo ${dates[@]}

mars=/home/fact/SW.automatic.processing/Mars.svn.2013.04.29
cd $mars

# do filling of aux data 
for date in ${dates[@]}
do 
   runnumber=`echo $date | sed -e 's/\///g'`
   
   # data which are not processed in LP
   if [ $runnumber -lt 20121212 ]
   then
      continue
   fi
   
   echo "run numevts.C for night "$runnumber" (run-wise processing) " >> $logfile 2>&1
   printprocesslog "run numevts.C for night "$runnumber" (run-wise processing) "
   printprocesslog "root -q -b -l fact/processing/numevents.C\("\"$runnumber"\"\,"\"$anapath"\"\,"\"$resulttable1"\"\,kFALSE\,kFALSE\)"
   check1=`root -q -b -l fact/processing/numevents.C\("\"$runnumber"\"\,"\"$anapath"\"\,"\"$resulttable1"\"\,kFALSE\,kFALSE\) | tee $logfile | intgrep`

   case $check1 in
      1)   printprocesslog "INFO filling numevts.C was successfully (check1=$check1)"
           ;;
      0)   printprocesslog "WARN connection to DB failed in numevts.C (check1=$check1)"
           ;;
      *)   printprocesslog "ERROR numevts.C failed (check1=$check1)"
           ;;
   esac

   #echo "run numevts.C for night "$runnumber" (night-wise processing) "
   #root -q -b -l fact/processing/numevts.C\("\"$runnumber"\"\,"\"$inpath"\"\,"\"$resulttable2"\"\,kFALSE\,kTRUE\)

done

finish


