#!/bin/bash

# option 
doupdate="yes" # update all entries (needed when new fields have been added)
#doupdate="no" # fill only entries which are not yet existing (default)

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 with option doupdate="$doupdate

logfile=$runlogpath"/FillCurrents-"$datetime".log"
date >> $logfile

# setup to use ftools
source $HEADAS/headas-init.sh

# check if software is available
if ! ls $factpath/fitsdump >/dev/null 2>&1
then 
   printprocesslog "ERROR "$factpath"/fitsdump is not available."
   finish
fi


# get last 3, 6 or 9 nights
#dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` `date +%Y/%m/%d --date="-60hour"` \
#        `date +%Y/%m/%d --date="-84hour"` `date +%Y/%m/%d --date="-108hour"` `date +%Y/%m/%d --date="-132hour"` \
#        `date +%Y/%m/%d --date="-156hour"` `date +%Y/%m/%d --date="-180hour"` `date +%Y/%m/%d --date="-204hour"` \
#        )
#dates=( `find -L $ziprawdata -mindepth 3 -type d | sort -r | sed "s/\${ziprawdata_for_sed}//g" | sed -e 's/^\///'` ) #all available dates in /loc_data/zipraw

dates=("2013/05/08 2013/05/07 2013/05/06 2013/05/05 2013/05/04 2013/05/03 2013/05/02 2013/05/01 2013/04/30 2013/04/29 2013/04/28 2013/04/27 2013/04/22 2013/04/21 2013/04/20 2013/04/19 2013/04/18 2013/04/17 2013/04/16 2013/04/15 2013/04/14 2013/04/13 2013/04/10 2013/04/09 2013/04/08 2013/04/07 2013/04/06 2013/04/05 2013/04/01 2013/03/31 2013/03/30 2013/03/29 2013/03/28 2013/03/25 2013/03/24 2013/03/23 2013/03/22 2013/03/21 2013/03/20 2013/03/19 2013/03/18 2013/03/17 2013/03/15 2013/03/14 2013/03/13 2013/03/12 2013/03/11 2013/03/09 2013/03/08 2013/03/07 2013/03/06 2013/03/02 2013/02/22 2013/02/20 2013/02/17 2013/02/16 2013/02/15 2013/02/14 2013/02/10 2013/02/09 2013/02/08 2013/02/07 2013/02/06 2013/02/05 2013/02/04 2013/02/03 2013/02/02 2013/02/01 2013/01/31 2013/01/30 2013/01/29 2013/01/28 2013/01/27 2013/01/24 2013/01/23 2013/01/22 2013/01/21 2013/01/20 2013/01/19 2013/01/18 2013/01/17 2013/01/16 2013/01/15 2013/01/14 2013/01/13 2013/01/12 2013/01/11 2013/01/10 2013/01/09 2013/01/08 2013/01/07 2013/01/06 2013/01/05 2013/01/04 2013/01/03 2013/01/02 2012/12/23 2012/12/22 2012/12/21 2012/12/20 2012/12/19 2012/12/18 2012/12/17 2012/12/16 2012/12/15 2012/12/14 2012/12/13 2012/12/11 2012/12/10 2012/12/09 2012/12/08 2012/12/07 2012/12/06 2012/12/05 2012/12/04 2012/12/03 2012/12/02 2012/12/01 2012/11/26 2012/11/24 2012/11/23 2012/11/22 2012/11/21 2012/11/20 2012/11/19 2012/11/18 2012/11/17 2012/11/15 2012/11/14 2012/11/13 2012/11/12 2012/11/09 2012/11/08 2012/10/26 2012/10/25 2012/10/24 2012/10/23 2012/10/22 2012/10/21 2012/10/20 2012/10/17 2012/10/16 2012/10/15 2012/10/12 2012/10/11 2012/10/10 2012/10/09 2012/10/08 2012/10/06 2012/10/05 2012/10/04 2012/10/03 2012/10/02 2012/10/01 2012/09/26 2012/09/25 2012/09/24 2012/09/23 2012/09/22 2012/09/21 2012/09/20 2012/09/19 2012/09/18 2012/09/17 2012/09/16 2012/09/13 2012/08/22 2012/08/21 2012/08/20 2012/08/19 2012/08/18 2012/08/13 2012/08/12 2012/08/10 2012/08/09 2012/08/08 2012/08/07 2012/08/04 2012/08/03 2012/08/02 2012/08/01 2012/07/31 2012/07/30 2012/07/28 2012/07/27 2012/07/26 2012/07/25 2012/07/24 2012/07/23 2012/07/18 2012/07/16 2012/07/15 2012/07/14 2012/07/13 2012/07/12 2012/07/11 2012/07/10 2012/07/09 2012/07/08 2012/07/07 2012/07/06 2012/07/05 2012/07/02 2012/07/01 2012/06/30 2012/06/29 2012/06/28 2012/06/27 2012/06/26 2012/06/25 2012/06/24 2012/06/23 2012/06/22 2012/06/21 2012/06/20 2012/06/19 2012/06/18 2012/06/17 2012/06/16 2012/06/15 2012/06/14 2012/06/13 2012/06/12 2012/06/11 2012/06/10 2012/06/09 2012/06/08 2012/06/07 2012/06/06 2012/06/05 2012/06/01 2012/05/31 2012/05/30 2012/05/29 2012/05/28 2012/05/27 2012/05/26 2012/05/25 2012/05/24 2012/05/23 2012/05/22 2012/05/21 2012/05/20 2012/05/18 2012/05/17 2012/05/16 2012/05/15 2012/05/14 2012/05/13 2012/05/12 2012/05/10 2012/05/09 2012/05/08 2012/05/03 2012/04/17 2012/04/16 2012/04/15 2012/04/14 2012/04/13 2012/04/12 2012/04/10 2012/04/09 2012/04/08 2012/04/06 2012/04/05 2012/04/03 2012/03/30 2012/03/29 2012/03/28 2012/03/27 2012/03/26 2012/03/25 2012/03/24 2012/03/22 2012/03/21 2012/03/20 2012/03/18 2012/03/17 2012/03/16 2012/03/15 2012/03/14 2012/03/13 2012/03/12 2012/03/11 2012/03/10 2012/03/09 2012/03/08 2012/03/06 2012/03/05 2012/03/04 2012/03/03 2012/03/02 2012/03/01 2012/02/29 2012/02/28 2012/02/27 2012/02/26 2012/02/25 2012/02/24 2012/02/23 2012/02/22 2012/02/21 2012/02/20 2012/02/19 2012/02/18 2012/02/17 2012/02/16 2012/02/09 2012/02/08 2012/02/04 2012/02/03 2012/02/02 2012/02/01 2012/01/31 2012/01/26 2012/01/25 2012/01/24 2012/01/23 2012/01/21 2012/01/20 2012/01/19 2012/01/17 2012/01/15 2012/01/14 2012/01/13 2011/12/13 2011/12/12 2011/12/08 2011/12/07 2011/12/06 2011/12/05 2011/12/03 2011/12/02 2011/12/01 2011/11/30 2011/11/29 2011/11/28 2011/11/27 2011/11/26 2011/11/25 2011/11/24 2011/11/23 2011/11/22 2011/11/21 2011/11/20 2011/11/19 2011/11/18 2011/11/17 2011/11/16 2011/11/15 2011/11/10 2011/11/09 2011/11/08 2011/11/07 2011/11/06 2011/11/05 2011/11/04 2011/11/03 2011/11/02 2011/11/01 2011/10/31 2011/10/30 2011/10/29 2011/10/28 2011/10/26 2011/10/25 2011/10/24 2011/10/19 2011/10/17 2011/10/16 2011/10/15 2011/10/14 2011/10/13 2011/10/12 2011/10/11 2011/10/10 2011/10/09 2011/10/06 2011/09/17 2011/09/16 2011/09/15 2011/09/14 2011/09/13 2011/09/12 2011/09/11 2011/09/10 2011/09/09 2011/09/08 2011/09/07 2011/09/06 2011/09/05 2011/09/02 2011/08/24 2011/08/23 2011/08/11 2011/08/09 2011/08/08 2011/08/05 2011/08/04 2011/08/03 2011/08/02 2011/07/27 2011/07/22")

#dates=( "2013/05/28" )

printprocesslog "INFO processing the following night(s): "${dates[@]}
echo  `date`": processing the following night(s): "${dates[@]} >> $logfile 2>&1

#echo ${dates[@]}

cd $mars

# do filling of aux data 
for date in ${dates[@]}
do 
   auxdir=$auxdata/$date
   runnumber=`echo $date | sed -e 's/\///g'`
   
   if [ $runnumber -lt 20130301 ]
   then
      continue
   fi

   # check if aux files are available from that night
   if ! [ -d $auxdir ]
   then
      printprocesslog "INFO no data available in "$auxdir
      continue
   else
      printprocesslog "INFO processing files in "$auxdir
   fi
   
   biasvoltagefile=$auxdir/$runnumber.BIAS_CONTROL_VOLTAGE.fits
   if ! [ -e $biasvoltagefile ]
   then 
      printprocesslog "WARN "$biasvoltagefile" not found."
      continue
   else
      biasnumerrors=`fverify $biasvoltagefile 2>/dev/null | grep -o '[0-9][ ]error(s)'  | grep -E -o '[0-9]'`
      if [ $biasnumerrors -gt 0 ]
      then 
         printprocesslog "WARN for $biasvoltagefile fverify returned "$biasnumerrors" error(s)."
      fi
   fi

   biascurrentfile=$auxdir/$runnumber.BIAS_CONTROL_CURRENT.fits
   if ! [ -e $biascurrentfile ]
   then 
      printprocesslog "WARN "$biascurrentfile" not found."
      continue
   else
      biascurrnumerrors=`fverify $biascurrentfile 2>/dev/null | grep -o '[0-9][ ]error(s)'  | grep -E -o '[0-9]'`
      if [ $biascurrnumerrors -gt 0 ]
      then 
         printprocesslog "WARN for $biascurrentfile fverify returned "$biascurrnumerrors" error(s)."
      fi
   fi

   feedbackcalfile=$auxdir/$runnumber.FEEDBACK_CALIBRATION.fits
   if ! [ -e $feedbackcalfile ]
   then 
      printprocesslog "WARN "$feedbackcalfile" not found."
      continue
   else
      feedbacknumerrors=`fverify $feedbackcalfile 2>/dev/null | grep -o '[0-9][ ]error(s)'  | grep -E -o '[0-9]'`
      if [ $feedbacknumerrors -gt 0 ]
      then 
         printprocesslog "WARN for $feedbackcalfile fverify returned "$feedbacknumerrors" error(s)."
      fi
   fi

   calcurrentsfile=$auxdir/$runnumber.FEEDBACK_CALIBRATED_CURRENTS.fits
   if ! [ -e $calcurrentsfile ]
   then 
      printprocesslog "INFO run calibrate.C for night "$runnumber
      printprocesslog "INFO run calibrate.C for night "$runnumber >> $logfile 2>&1
      root -q -b -l fact/calibrate.C\($runnumber\)
      calcurrentsfile=/gpfs/scratch/fact/calibrated_currents/$runnumber.CALIBRATED_CURRENTS.fits
   fi

   #calcurrentsfile=$auxdir/$runnumber.FEEDBACK_CALIBRATED_CURRENTS.fits
   #calcurrentsfile=/scratch_nfs/calibrated_currents/$runnumber.CALIBRATED_CURRENTS.fits
   #calcurrentsfile=/gpfs/scratch/fact/calibrated_currents/$runnumber.CALIBRATED_CURRENTS.fits
   if ! [ -e $calcurrentsfile ]
   then 
      printprocesslog "WARN "$calcurrentsfile" not found."
      continue
   else
      calnumerrors=`fverify $calcurrentsfile 2>/dev/null | grep -o '[0-9][ ]error(s)'  | grep -E -o '[0-9]'`
      if [ $calnumerrors -gt 0 ]
      then 
         printprocesslog "WARN for $calcurrentsfile fverify returned "$calnumerrors" error(s)."
      fi
   fi
   

   # get file numbers from DB
   #   but only for not-corrupted files
   query="SELECT fRunID from RunInfo WHERE fNight="$runnumber" AND fFitsFileErrors=0 "
   if [ "$doupdate" = "no" ]
   then
      query=$query" AND ISNULL(fCurrentsMedMean) "
   fi

   printprocesslog "DEBUG get filenumbers from DB: QUERY: "$query
   filenumbers=( `sendquery $query` )
   if [ ${#filenumbers} -eq 0 ]
   then
      printprocesslog "INFO No files found in the DB for night "$date
      continue
   fi

   # fill auxiliary information for files
   for filenum in ${filenumbers[@]}
   do
      printprocesslog "INFO processing file number "$runnumber"_"`printf %03d $filenum`
      echo  `date`": processing file number "$runnumber"_"`printf %03d $filenum` >> $logfile 2>&1
      # get information from rawfile
      rawfile=$ziprawdata/$date/$runnumber"_"`printf %03d $filenum`.fits.gz
      if ! [ -e $rawfile ]
      then 
         printprocesslog "ERROR: "$rawfile" not found."
         continue
      fi
      runtype=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep RUNTYPE | grep -E -o "['][a-z-]+[']" | sed -e "s/'//g"`
      mjdrefraw=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep 'MJDREF' | grep -E -o '[0-9]{5}'`
      tstarti=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep 'TSTARTI' | grep -E -o '[0-9]{5}'`
      tstartf=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep 'TSTARTF' | grep -E -o '0[.][0-9]+'`
      tstopi=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep 'TSTOPI' | grep -E -o '[0-9]{5}'`
      tstopf=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep 'TSTOPF' | grep -E -o '0[.][0-9]+'`
      if [ "$tstarti" == "" ] || [ "$tstopi" == "" ] || [ "$tstartf" == "" ] || [ "$tstopf" == "" ]
      then 
         printprocesslog "WARN: "$rawfile": one of the following keywords is empty or 0: TSTARTI TSTARTF TSTOPI TSTOPF "
         continue
      fi
      # assuming that at least TSTARTI and TSTOPI are consistent
      #echo $rawfile
      #echo $tstarti
      #echo $tstopi
      #echo $tstartf
      #echo $tstopf
      if [ $tstarti -gt 30000 ]
      then 
         tstart=`echo " $tstarti + $tstartf - 40587 " | bc -l`
         tstart2=`echo " $tstarti + $tstartf - 40587 - 0.00011574 " | bc -l`  # 10 sec
         #tstart2=`echo " $tstarti + $tstartf - 40587 - 0.000023148 " | bc -l` # 2 sec
         tstop=`echo " $tstopi + $tstopf - 40587 " | bc -l`
      else
         tstart=`echo " $tstarti + $tstartf " | bc -l`
         tstart2=`echo " $tstarti + $tstartf - 0.00011574 " | bc -l`  # 10 sec
         #tstart2=`echo " $tstarti + $tstartf - 0.000023148 " | bc -l` # 2 sec
         tstop=`echo " $tstopi + $tstopf " | bc -l`
      fi

      # build query to update runinfo in DB
      query="UPDATE RunInfo SET "

      # get information from fsc: T[31]
      if [ -e $calcurrentsfile ] && [ $calnumerrors -eq 0 ]
      then 
         #root -q -b -l fact/curavg.C\("\"$calcurrentsfile\""\,$tstart\,$tstop\) # | grep "result" | grep -E -o '[0-9]+[.]?[0-9]*'
         #currents=( `root -q -b -l fact/curavg.C\("\"$calcurrentsfile\""\,$tstart\,$tstop\) | grep "result" | grep -E -o '[0-9]+[.]?[0-9]*'` )
         currents=( `root -q -b -l fact/processing/currents.C\("\"$calcurrentsfile\""\,$tstart\,$tstop\) | grep "result" | grep -E -o '[-]?[0-9]+[.]?[0-9]*'` )
         if [ "${currents[0]}" == "" ]
         then 
            query=$query"fCurrentsMedMean=NULL"
         else
            query=$query"fCurrentsMedMean="${currents[0]}
         fi
         if [ "${currents[1]}" == "" ]
         then 
            query=$query", fCurrentsMedRms=NULL"
         else
            query=$query", fCurrentsMedRms="${currents[1]}
         fi
         if [ "${currents[2]}" == "" ]
         then 
            query=$query", fCurrentsDevMean=NULL"
         else
            query=$query", fCurrentsDevMean="${currents[2]}
         fi
         if [ "${currents[3]}" == "" ]
         then 
            query=$query", fCurrentsDevRms=NULL"
         else
            query=$query", fCurrentsDevRms="${currents[3]}
         fi
         if [ "${currents[4]}" == "" ]
         then 
            query=$query", fCurrentsMedMeanBeg=NULL"
         else
            query=$query", fCurrentsMedMeanBeg="${currents[4]}
         fi
         if [ "${currents[5]}" == "" ]
         then 
            query=$query", fCurrentsMedMeanEnd=NULL"
         else
            query=$query", fCurrentsMedMeanEnd="${currents[5]}
         fi
         if [ "${currents[6]}" == "" ]
         then
            query=$query", fCurrentsDiffToPrediction=NULL"
         else
            query=$query", fCurrentsDiffToPrediction="${currents[6]}
         fi
      else
         query=$query" fCurrentsMedMean=NULL"
         query=$query", fCurrentsMedRms=NULL"
         query=$query", fCurrentsDevMean=NULL"
         query=$query", fCurrentsDevRms=NULL"
         query=$query", fCurrentsMedMeanBeg=NULL"
         query=$query", fCurrentsMedMeanEnd=NULL"
         query=$query", fCurrentsDiffToPrediction=NULL"
      fi
      
      # add where condition
      query=$query" WHERE fNight="$runnumber" AND fRunID="$filenum
      
      #echo $query
      # send query to DB
      sendquery >/dev/null
   done
done

finish


