#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

# get and check variables
if ! [ "$1" = "" ]
then
   dsfile=$1
   ra=$2
   dec=$3
fi

if [ "$dsfile" = "" ]
then
   echo "ERROR variable dsfile empty."
   printprocesslog "ERROR variable dsfile empty."
fi

if [ "$ra" = "" ]
then
   echo "ERROR variable ra empty."
   printprocesslog "ERROR variable ra empty."
fi

if [ "$dec" = "" ]
then
   echo "ERROR variable dec empty."
   printprocesslog "ERROR variable dec empty."
fi

outpath=`dirname $dsfile | sed -e 's/datasets/ganymed/'`
makedir $outpath

dsnum=`basename $dsfile | sed -e 's/dataset//' -e 's/[.]txt//'`
output=$outpath/$dsnum
logfile=$output"-ganymed.log"

cd $mars

# run ganymed 
printprocesslog "INFO starting ganymed.C for dataset "$dsfile
#echo "INFO starting ganymed.C for dataset "$dsfile

printprocesslog "INFO command: root -q -b fact/analysis/ganymed.C\("\"$dsfile\""\,"\"$output\""\,$ra\,$dec\) | tee $logfile | intgrep"
check1=`root -q -b fact/analysis/ganymed.C\("\"$dsfile\""\,"\"$output\""\,$ra\,$dec\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO ganymed.C was successful for dataset "$dsfile" ra "$ra" dec "$dec" (check1=$check1)"
        ;;
   *)   printprocesslog "ERROR ganymed.C failed for dataset "$dsfile" ra "$ra" dec "$dec" (check1=$check1)"
        ;;
esac

finish 

