#!/bin/bash

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

doupdate="yes"
#doupdate="no"

# get all nights
getdates "all"
# get one single night
#getdates "2013/08/13"
# get several nights
#getdates 15

usesge="yes"
#usesge="no"

echo ${dates[@]}

scripts=( \
#        ~/DataCheck/Processing/FillAuxCurrents.sh \
#        ~/DataCheck/Processing/FillAuxTemp.sh \
#        ~/DataCheck/Processing/FillDrsTemp.sh \
#        ~/DataCheck/Processing/FillAuxData.sh \
#	~/DataCheck/QuickLook/Step2a.sh \
#        ~/DataCheck/Processing/FillEffectiveOn.sh \
        ~/DataCheck/Processing/FillNumEvts.sh \
#        ~/DataCheck/Processing/FillAuxThresholds.sh \
#        ~/DataCheck/Processing/FillMoonInfo.sh \
        )

# start scripts for that night
for date in ${dates[@]}
do 
   echo $date
   for script in ${scripts[@]}
   do
#      echo $script" for "$date
      name=`basename $script | sed -e 's/Fill//' -e 's/Aux//' | cut -c 1-3``echo $date | sed -e 's/\///g'`
      date2=`echo $date | sed -e 's/\//-/g' | cut -c 3-8`
      #echo $name 
      if [ "$usesge" = "yes" ]
      then 
         echo "INFO submitting "$script" to the cluster for the night "$date
         printprocesslog "INFO submitting "$script" to the cluster for the night "$date
         $sgepath/qsub -b y -q fact_medium -v doupdate=$doupdate -v certaindate=$date -v AUTOMATIONSETUP=$AUTOMATIONSETUP -e $runlogpath"/error-"$date2".log" -o $runlogpath"/log-"$date2".log" -N $name $script $date
      else
         echo "INFO starting "$script" for date "$date" on "$HOST" ... "
         printprocesslog "INFO starting "$script" for date "$date" on "$HOST" ... "
         export certaindate="$date"
         export doupdate="$doupdate"
         $script #&
      fi
   done
done

finish


