#!/bin/bash

if [ "$#" != 3 ]
then
	echo "Error: fixAuxKeyWords.sh should be called with 2 arguments. Aborting."
	exit
fi

file=$1
tempFile="/scratch/tempRaw.txt"
reportFile=$2
processErrors=$3

if [ -a $tempFile ]
then
	rm $tempFile 2>/dev/null
fi

#get current keywords value
result=`/home_nfs/isdc/lyard/FACT++/fitsdump $file -h -o $tempFile 2>/dev/null`

if [ -a $tempFile ]
then
	timesys=`grep 'TIMESYS' $tempFile | grep -E -o 'UTC'`
	mjdref=`grep 'MJDREF' $tempFile | grep -E -o '[-]*[0-9]*[.]*[0-9]+'`
	tstarti=`grep 'TSTARTI' $tempFile | grep -E -o '[-]*[0-9]*[.]*[0-9]+'`
	tstartf=`grep 'TSTARTF' $tempFile | grep -E -o '[-]*[0-9]*[.]*[0-9]+'`
	tstopi=`grep 'TSTOPI' $tempFile | grep -E -o '[-]*[0-9]*[.]*[0-9]+'`
	tstopf=`grep 'TSTOPF' $tempFile | grep -E -o '[-]*[0-9]*[.]*[0-9]+'`
	date_obs=`grep 'DATE-OBS' $tempFile`
	date_end=`grep 'DATE-END' $tempFile`
	telescope=`grep 'TELESCOP' $tempFile`
	package=`grep 'PACKAGE' $tempFile`
	origin=`grep 'ORIGIN' $tempFile`
	timeunit=`grep 'TIMEUNIT' $tempFile`
else
	echo "Could not list keywords in $file" >> $processErrors
	exit
fi

rm $tempFile

#retrieve the start and stop time from the data itself
result=`/home_nfs/isdc/lyard/FACT++/fitsdump $file -c UnixTimeUTC --minmax --nozero -o $tempFile 2>/dev/null`

if [ -a $tempFile ]
then
	tstart=`grep 'min' $tempFile | grep -E -o '[-]*[0-9]*[.]*[0-9]+'`
	tstop=`grep 'max' $tempFile | grep -E -o '[-]*[0-9]*[.]*[0-9]+'`
	tstarti2=`echo $tstart | grep -E -o '[-]*[0-9]*[.]' | grep -E -o '[-]*[0-9]*'`
	tstartf2=`echo $tstart | grep -E -o '[.][0-9]+'`
	tstartf2="0"$tstartf2
	tstopi2=`echo $tstop | grep -E -o '[-]*[0-9]*[.]' | grep -E -o '[-]*[0-9]*'`
	tstopf2=`echo $tstop | grep -E -o '[.][0-9]+'`
	tstopf2="0"$tstopf2
else
	#let's give it a shot with PCTime
	result=`/home_nfs/isdc/lyard/FACT++/fitsdump $file -c PCTime --minmax --nozero -o $tempFile 2>/dev/null`
	if [ -a $tempFile ]
	then
		tstart=`grep 'min' $tempFile | grep -E -o '[-]*[0-9]*[.]*[0-9]+'`
		tstop=`grep 'max' $tempFile | grep -E -o '[-]*[0-9]*[.]*[0-9]+'`
		tstarti2=`echo $tstart | grep -E -o '[-]*[0-9]*[.]' | grep -E -o '[-]*[0-9]*'`
		tstartf2=`echo $tstart | grep -E -o '[.][0-9]+'`
		if [ "$tstarti2" == "" ] #no decimal part
		then
			tstarti2=$tstart
		fi
		tstartf2="0"$tstartf2
		tstopi2=`echo $tstop | grep -E -o '[-]*[0-9]*[.]' | grep -E -o '[-]*[0-9]*'`
		tstopf2=`echo $tstop | grep -E -o '[.][0-9]+'`
		if [ "$tstopi2" == "" ] #no decimal part
		then
			tstopi2=$tstop
		fi
		tstopf2="0"$tstopf2
	else
#	echo "Could not minmax $file" >> $processErrors
		exit
	fi
fi

rm $tempFile
#output the values to be added/updated to temp text files
modified="false"
if [ "$telescope" == "" ]
then
	echo "TELESCOP FACT / Telescope that acquired this data" >> $tempFile
	modified="true"
	echo "TELESCOP in $file" >> $2
fi
if [ "$package" == "" ]
then
	echo "PACKAGE FACT++ / Package name" >> $tempFile
	modified="true"
	echo "PACKAGE in $file" >> $2
fi
if [ "$origin" == "" ]
then
	echo "ORIGIN FACT / Institution that wrote the file" >> $tempFile
	modified="true"
	echo "ORIGIN in $file" >> $2
fi
if [ "$timeunit" == "" ]
then
	echo "TIMEUNIT d / Time given in days w.r.t. to MJDREF" >> $tempFile
	modified="true"
	echo "TIMEUNIT in $file" >> $2
fi
if [ "$mjdref" == "" ]
then
#	mjdref="0"
	mjdref="40587"
	echo "MJDREF "$mjdref" / Store times in UNIX time (sec from 1970ish)" >> $tempFile
	modified="true"
	echo "MJDREF in $file" >> $2
fi
if [ "$timesys" != "UTC" ]
then
	timesys="UTC"
	echo "TIMESYS "$timesys" / Time system" >> $tempFile
	modified="true"
	echo "TIMESYS in $file" >> $2
fi
#adapt the start and stop to the mjdref (it is raw unix time in the data)
if [ "$tstarti2" != "0" ] && [ "$tstarti2" != "" ]
then
	tstarti2=`echo "$tstarti2 - $mjdref" | bc -l`
	tstopi2=`echo "$tstopi2 - $mjdref" | bc -l`
else
	tstarti2=0
	tstopi2=0
fi

#give latitude for 10-6 precision in tstart and tstop
tfcompare=`echo $tstartf | grep -E -o '0\.[0-9]{6}'`
tfcompare2=`echo $tstartf2 | grep -E -o '0\.[0-9]{6}'`

if [ "$tstarti2" != "$tstarti" ] || [ "$tfcompare" != "$tfcompare2" ] 
then
	echo "TSTARTI "$tstarti2" / Time when first event received (integral part)" >> $tempFile
	echo "TSTARTF "$tstartf2" / Time when first event received (fractional part)" >> $tempFile
	date_obs2=`echo "$tstarti2 + $tstartf2 + $mjdref" | bc -l`
	date_obs2=`/home_nfs/isdc/lyard/FACT++/MjDtoISO $date_obs2`
	echo "DATE-OBS "$date_obs2" / Time when first event was received" >> $tempFile
	modified="true"
	echo "TSTART in $file" >> $2
fi

tfcompare=`echo $tstopf | grep -E -o '0\.[0-9]{6}'`
tfcompare2=`echo $tstopf2 | grep -E -o '0\.[0-9]{6}'`

if [ "$tstopi2" != "$tstopi" ] || [ "$tfcompare" != "$tfcompare2" ]
then

	echo "first: $tfcompare |||  second: $tfcompare2||"
	echo "TSTOPI "$tstopi2" / Time when last event received (integral part)" >> $tempFile
	echo "TSTOPF "$tstopf2" / Time when last event received (fractional part)" >> $tempFile
	date_end2=`echo "$tstopi2 + $tstopf2 + $mjdref" | bc -l`
	date_end2=`/home_nfs/isdc/lyard/FACT++/MjDtoISO $date_end2`
	echo "DATE-END "$date_end2" / Time when last event was received" >> $tempFile
	modified="true"
	echo "TSTOP  in $file" >> $2
fi

if [ "$modified" == "true" ]
then
	echo "INGEST v0.2 Version of Etienne ingest script" >> $tempFile
	echo $file" header has been modified" >> $reportFile
else
	echo $file" header has NOT been modified" >> $reportFile
fi

if [ -a $tempFile ]
then
	fmodhead $file $tempFile 2>&1 1>/dev/null
fi

fchecksum $file update+ 2>&1 1>/dev/null

rm $tempFile 2>/dev/null
