#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=RsyncRawToISDC
step=RawFileRsyncedISDC
pwfile=/home_nfs/isdc/fact_opr/rsync.pwd

set -C

logfile=$runlogpath"/RsyncRawToISDC-"$datetime".log"
date >> $logfile 2>&1

# check if script is already running
lockfile=$lockpath/lock-$program.txt
checklock 

# get todo list
gettodo 

for (( s=0 ; s < $num ; s++ ))
do
   night=${primaries[$s+$s]}
   runid=${primaries[$s+$s+1]}
   nightpath=`echo $night | cut -c 1-4`"/"`echo $night | cut -c 5-6`"/"`echo $night | cut -c 7-8`
   
   setstatus "start" 

   rawfilelp="/loc_data/zipraw/./"$nightpath"/"$night"_"`printf %03d $runid`".fits.gz"
   rawdirisdc="/scratch/from_lapalma/raw/"
   rawfileisdc=$rawdirisdc$nightpath"/"$night"_"`printf %03d $runid`".fits.gz"
   ingestlinkpath="/scratch/ingest_links/raw/"$nightpath
   makedir $ingestlinkpath >> $logfile 2>&1
   ingestlink=$ingestlinkpath"/"$night"_"`printf %03d $runid`".fits.gz"

   # for new rsync
   #   remove / from dir
   #   change name of dir (else rsync-server doesn't accept it
   #   test if trick with file/dir is working
   #echo "INFO rsync rawfile "$rawfilelp" to ISDC "$rawdirisdc
   printprocesslog "INFO rsync rawfile "$rawfilelp" to ISDC "$rawdirisdc
   #echo "INFO rsync rawfile "$rawfilelp" to ISDC "$rawdirisdc >> $logfile 2>&1
   #rsync -rltDvR --partial --stats --password-file=$pwfile factdata@161.72.93.131::$rawfilelp $rawdirisdc >> $logfile 2>&1
   #echo "rsync -rltDvR -T $rsynctempdir --partial --stats fact@161.72.93.131:$rawfilelp $rawdirisdc >> $logfile 2>&1"
   rsync -rltDvR -T $rsynctempdir --partial --stats fact@161.72.93.131:$rawfilelp $rawdirisdc >> $logfile 2>&1
   check1=$?

   case $check1 in
      0)   printprocesslog "INFO rawfile "$rawfilelp" transferred successfully to ISDC."
           if ! [ -L $ingestlink ]
           then 
              printprocesslog "INFO create link for "$rawfileisdc
              ln -sv $rawfileisdc $ingestlink >> $logfile 2>&1
              check2=$?
              case $check2 in
                 0)   printprocesslog "INFO link for  "$rawfileisdc" created successfully."
                      ;;
                 *)   printprocesslog "WARN link for "$rawfileisdc" could not be created (check2="$check2")."
                      check=$check2
                      ;;
              esac
           else
              printprocesslog "INFO link "$ingestlink" already existing."
           fi
           ;;
      *)   printprocesslog "WARN "$rawfilelp" could not be transferred to ISDC (check1="$check1")."
           check=$check1
           ;;
   esac
   
   query="SELECT fHasDrsFile from RunInfo WHERE fNight="$night" AND fRunID="$runid
   numdrs=`sendquery`
   if [ $numdrs -gt 0 ]
   then 
      drsfilelp="/loc_data/zipraw/./"$nightpath"/"$night"_"`printf %03d $runid`".drs.fits.gz"
      drsfileisdc=$rawdirisdc$nightpath"/"$night"_"`printf %03d $runid`".drs.fits.gz"
      drsingestlink=$ingestlinkpath"/"$night"_"`printf %03d $runid`".drs.fits.gz"
      printprocesslog "INFO rsync drsfile "$drsfilelp" to ISDC "$rawdirisdc
      echo "INFO rsync drsfile "$drsfilelp" to ISDC "$rawdirisdc >> $logfile 2>&1
      #rsync -rltDvR --partial --stats --password-file=$pwfile factdata@161.72.93.131::$rawfilelp $rawdirisdc >> $logfile 2>&1
      rsync -rltDvR -T $rsynctempdir --partial --stats fact@161.72.93.131:$drsfilelp $rawdirisdc >> $logfile 2>&1
      check3=$?

      case $check3 in
         0)   printprocesslog "INFO drsfile "$drsfilelp" transferred successfully to ISDC."
              if ! [ -L $drsingestlink ]
              then 
                 printprocesslog "INFO create link for "$drsfileisdc
                 ln -sv $drsfileisdc $drsingestlink >> $logfile 2>&1
                 check4=$?
                 case $check4 in
                    0)   printprocesslog "INFO link for  "$drsfileisdc" created successfully."
                         ;;
                    *)   printprocesslog "WARN link for "$drsfileisdc" could not be created (check4="$check4")."
                         check=$check4
                         ;;
                 esac
              else
                 printprocesslog "INFO link "$drsingestlink" already existing."
              fi
              ;;
         *)   printprocesslog "WARN "$drsfilelp" could not be transferred to ISDC (check3="$check3")."
              check=$check3
              ;;
      esac
   fi

   setstatus "stop" 
done

finish 

