#!/bin/bash
#
# Script to copy scheduling plots to the web
#

# remarks:
#
# be aware that the script only writes files which don't exist yet
# i.e. in case of a new sw version, old files have to be deleted or moved away
#
# script to be executed on gate, i.e. FACT++ there has to be up-to-date

# create plots for past night
direction="-"
# create plots for future nights
direction="+"

# number of days to be treated
numdays=1000


plot=/home/fact/FACT++.in-run-fad-loss/makeplots
plot=/home/fact/FACT++/makeplots
root=/opt/root_svn/bin/thisroot.sh
inpathdata=/home/fact/scheduling.plots
inpathgate=/users/fact/scheduling.plots
inpath=/users/fact/scheduling.plots

# creating files for X days (if they don't exist yet)
for (( i=0; i < $numdays ; i++))
do 
   outpath=/home/factwww/scheduling/`date --date="${direction}${i}days" +%Y/%m/%d`
   date=`date --date="${direction}${i}days" +%Y-%m-%d`
   echo -n $date

   if ! [ -d $outpath ]
   then
      mkdir -p $outpath
   else
      echo $outpath" exists -> continue"
      continue 
   fi
   #file1=$outpath/visibility$date.png
   #file2=$outpath/currents$date.png
   #file3=$outpath/legend$date.png
   #if ! [ -e $file1 ] || ! [ -e $file2 ] || ! [ -e $file3 ] 
   #then
      echo -n ": creating files..."
      #ssh data "source $root ; cd $inpathdata ; $plot $date >/dev/null 2>&1"
      cd $outpath 
      $plot $date >/dev/null 2>&1
      ##pstoimg -quiet $inpathgate/test1.eps -scale 1.5 -out $file1
      #pstoimg -quiet test1.eps -scale 1.5 -out $file1
      ##pstoimg -quiet $inpathgate/test2.eps -scale 1.5 -out $file2
      #pstoimg -quiet test2.eps -scale 1.5 -out $file2
      ##pstoimg -quiet $inpathgate/legend.eps -scale 0.8 -out $file3
      #pstoimg -quiet legend.eps -scale 0.8 -out $file3
      # with the version of 25.3.2013 the files seem to have new names: 
      files=`ls *.eps`
      for file in $files
      do 
         if ls $file | grep Legend >/dev/null
         then
            scale=0.8
         else
            scale=1.5
         fi
         pstoimg -quiet -scale $scale $file
      done
   #fi
   echo ""
done
