#!/bin/bash
#
# This script backups the databases give in setup.XXX in the array dbnames
# 

today=`date +%F`
olday=`date +%F --date="-30day"`

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

set -C

logfile=$runlogpath"/BackupDatabase-"$datetime".log"
date >> $logfile

# store files on data
path=/users/fact/DB_Backup 

# getdbsetup

echo "today: $today" >> $logfile 2>&1
echo "date to remove: $olday" >> $logfile 2>&1

printprocesslog "INFO doing backup for the following databases: "${dbnames[@]}
echo "doing backup for the following databases: "${dbnames[@]}  >> $logfile 2>&1
for dbname in ${dbnames[@]}
do 
   filepath=$path/$dbname
   command=$filepath"/Create_"$dbname"_"$today".txt"
   oldcommand=$filepath"/Create_"$dbname"_"$olday".txt"
   mkdir -pv $filepath >> $logfile 2>&1

   file=$filepath/$dbname
   sqlfile=$file"_"$today".sql"
   oldzip=$file"_"$olday".sql.bz2"

   printprocesslog "INFO removing old files..."
   echo "removing old files..." >> $logfile 2>&1
   if ls $oldzip >/dev/null 2>&1
   then
      rm -v $oldzip >> $logfile 2>&1
   fi
   if ls $oldcommand >/dev/null 2>&1
   then
      rm -v $oldcommand >> $logfile 2>&1
   fi

   printprocesslog "INFO writing create commands for database '"$dbname"' to "$command
   echo "writing create commands for database '"$dbname"' to "$command >> $logfile 2>&1
   # commands to create db
   if ! mysqldump --host=localhost --database $dbname -u dump --no-data >| $command 2>> $logfile
   then
      printprocesslog "ERROR mysqldump failed for database '"$dbname"'"
      echo "ERROR mysqldump failed for "$dbname >> $logfile 2>&1
      rm -v $command  >> $logfile 2>&1
   fi

   printprocesslog "INFO writing database '"$dbname"' to "$sqlfile
   echo "writing database '"$dbname"' to "$sqlfile >> $logfile 2>&1
   # mysqldump of full DB
   if ! mysqldump --host=localhost --database $dbname -u dump >| $sqlfile 2>> $logfile
   then
      printprocesslog "ERROR mysqldump failed for database '"$dbname"'"
      echo "ERROR mysqldump failed for database '"$dbname"'" >> $logfile 2>&1
      rm -v $sqlfile  >> $logfile 2>&1
   else
      if ! bzip2 -9 $sqlfile >> $logfile 2>&1
      then 
         printprocesslog "ERROR zipping of "$sqlfile" failed." 
         echo "ERROR zipping of "$sqlfile" failed."  >> $logfile 2>&1
      fi
   fi
done

dbdirwue=/home/operator/budb/fact_from_lp
echo "" >> $logfile 2>&1
echo `date`": rsyncing files in "$path" to Wuerzburg (coma: "$dbdirwue")" >> $logfile 2>&1
printprocesslog "INFO rsyncing files in "$path" to Wuerzburg (coma: "$dbdirwue")"

#rsync from gate to coma
if ! /usr/bin/rsync -avxP $path operator@coma.astro.uni-wuerzburg.de:$dbdirwue >> $logfile 2>&1
then
   echo `date`": problem rsyncing database from LP ("$path") to Wuerzburg (coma:"$dbdirwue")" >> $logfile 2>&1
   printprocesslog "CONNECTION problem rsyncing database from LP ("$path") to Wuerzburg (coma:"$dbdirwue")"
fi

finish >> $logfile 2>&1

