#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

# get and check variables
if ! [ "$1" = "" ]
then
   starfile=$1
fi

if [ "$starfile" = "" ]
then
   echo "ERROR variable starfile empty."
   printprocesslog "ERROR variable starfile empty."
fi

# getting coordinates from raw and drive
date=`echo $starfile | grep -o -E '20[0-9][0-9]/[0-3][0-9]/[0-2][0-9]'`
drivefile=$auxdata"/"$date"/"`basename $starfile | cut -d_ -f1`".DRIVE_CONTROL_SOURCE_POSITION.fits"
rawfile=$rawdata"/"$date"/"`basename $starfile | sed -e 's/_I.root/.fits.fz/'`
if [ -e $rawfile ]
then 
   printprocesslog "INFO processing "$rawfile
   tstopi=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep TSTOPI | grep -E -o '[0-9]+'`
   tstopf=`$factpath/fitsdump -h $rawfile  2>/dev/null | grep TSTOPF | grep -E -o '[.][0-9]+'`
   tstop=${tstopi}${tstopf}
fi
if  ls $drivefile >/dev/null 2>&1  && ! [ "$tstop" == "" ]
then
   printprocesslog "INFO getting coordinates from "$drivefile
   coordinates=( `${factpath}/fitsdump ${drivefile} -c Ra_src Dec_src -r --filter='Time<'${tstop}  2>/dev/null | tail -1 2>&1` )
   if [ "${coordinates[0]}" == "" ] || [ "${coordinates[1]}" == "" ]
   then
      printprocesslog "WARN couldn't get coordinates ("${coordinates[@]}") from "$drivefile
      echo "WARN couldn't get coordinates ("${coordinates[@]}") from "$drivefile
      finish
   fi
   if [ "${coordinates[0]}" == "0" ] || [ "${coordinates[1]}" == "0" ]
   then
      printprocesslog "WARN coordinates "${coordinates[@]}
      echo "WARN coordinates "${coordinates[@]}
      finish
   fi
else
   printprocesslog "INFO getting coordinates from DB."
   query="SELECT fSourceKEY FROM RunInfo WHERE fNight="$night" AND fRunID="$runid
   sourcekey=`sendquery`
   if [ "$sourcekey" == "" ]
   then
      printprocesslog "WARN sourcekey empty - coordinates"${coordinates[@]}
      #echo "WARN sourcekey empty - coordinates"${coordinates[@]}" for "$rawfile
      finish
   fi
   query="SELECT Round(fRightAscension,6), Round(fDeclination,6) from Source WHERE fSourceKey="$sourcekey
   coordinates=( `sendquery` )
   if [ "${coordinates[0]}" == "" ] || [ "${coordinates[1]}" == "" ]
   then
      printprocesslog "WARN couldn't get coordinates ("${coordinates[@]}") from DB."
      #echo "WARN couldn't get coordinates ("${coordinates[@]}") from "$drivefile
      finish
   fi
   if [ "${coordinates[0]}" == "0" ] || [ "${coordinates[1]}" == "0" ]
   then
      printprocesslog "WARN coordinates "${coordinates[@]}
      #echo "WARN coordinates "${coordinates[@]}
      finish
   fi
fi
ra=${coordinates[0]}
dec=${coordinates[1]}


outpath=`dirname $starfile | sed -e 's/star/ganymed_run/'`
makedir $outpath

output=$outpath/`basename $starfile | cut -dI -f1`
logfile=$output"-ganymed.log"
ganymedfile=$output"-analysis.root"

cd $mars

# run ganymed 
printprocesslog "INFO starting ganymed.C for starfile "$starfile

printprocesslog "DEBUG root -q -b fact/analysis/ganymed.C\($ra\,$dec\,"\"$starfile\""\,"\"$output\""\) | tee $logfile | intgrep"
check1=`root -q -b fact/analysis/ganymed.C\($ra\,$dec\,"\"$starfile\""\,"\"$output\""\) | tee $logfile | intgrep`

case $check1 in
   0)   printprocesslog "INFO ganymed.C was successful for starfile "$starfile" ra "$ra" dec "$dec" (check1=$check1)"
        
        echo "run numevts.C for "$ganymedfile" for table "$resulttable1 >> $logfile 2>&1
        printprocesslog "INFO run numevts.C for "$ganyemdfile" for table "$resulttable1
        printprocesslog "DEBUG root -q -b -l fact/processing/numevents.C+\("\"$ganymedfile"\"\,"\"$starfile"\"\,"\"$resulttable1"\"\,kFALSE\)"
        check1=`root -q -b -l fact/processing/numevents.C+\("\"$ganymedfile"\"\,"\"$starfile"\"\,"\"$resulttable1"\"\,kFALSE\) | tee $logfile | intgrep`
        case $check1 in
           1)   printprocesslog "INFO filling numevts.C was successfully for "$ganymedfile" and table "$resulttable1" (check1=$check1)"
                ;;
           0)   printprocesslog "WARN connection to DB failed in numevts.C (check1=$check1)"
                ;;
           *)   printprocesslog "ERROR numevts.C failed for "$ganymedfile" and table "$resulttable1" (check1=$check1)"
                ;;
        esac
        ;;
   *)   printprocesslog "ERROR ganymed.C failed for starfile "$starfile" ra "$ra" dec "$dec" (check1=$check1)"
        ;;
esac

finish 

