#!/bin/bash
#
# Script to copy scheduling plots to the web
#

# remarks:
#
# be aware that the script only writes files which don't exist yet
# i.e. in case of a new sw version, old files have to be deleted or moved away
#
# script to be executed on gate, i.e. FACT++ there has to be up-to-date

# create plots for past (-) / future (+) night
directions=( "-" "+" )

# number of days to be treated
numdays=1000

plot=/home/fact/FACT++/makeplots
root=/opt/root_v5.34.10/bin/thisroot.sh

# creating files for X days (if they don't exist yet)
for (( i=0; i < $numdays ; i++))
do 
   for direction in ${directions[@]}
   do
      outpath=/home/factwww/scheduling/`date --date="${direction}${i}days" +%Y/%m/%d`
      date=`date --date="${direction}${i}days" +%Y-%m-%d`
      echo -n $date

      if ! [ -d $outpath ]
      then
         mkdir -p $outpath
      else
         echo $outpath" exists -> continue"
         continue 
      fi
      echo -n ": creating files..."
      cd $outpath 
      $plot $date --max-zd=75 --max-current=90 >/dev/null 2>&1
      files=`ls *.eps`
      for file in $files
      do 
         if ls $file | grep Legend >/dev/null
         then
            scale=0.8
         else
            scale=1.5
         fi
         pstoimg -quiet -scale $scale $file
      done
      echo ""
   done
done
