#!/bin/bash
#
source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

# fixme: get sources from DB
sources=( 1 2 5 7 )
#sources=( 1 2 5 )
numganymeds=0

printprocesslog "INFO get all nights."
query="SELECT fNight FROM RunInfo WHERE not isnull(fSourceKey) and fNight > 20130301 GROUP BY fNight ORDER BY fNight DESC"
nights=( `sendquery` )

for source in ${sources[@]}
do 
   dspath=$anapath/datasets_night/$source
   makedir $dspath >/dev/null
done

for night in ${nights[@]}
do 
   echo $night
   for source in ${sources[@]}
   do 
      dspath=$anapath/datasets_night/$source
      dsfile=$dspath"/dataset"$night".txt"
      if ! ls $dsfile >/dev/null 2>&1
      then
         echo "# source "$source" for night "$night > $dsfile
         linesold=0
      else
         lines=( `wc -l $dsfile` )
         linesold[$source]=${lines[0]}
      fi
   done

   inpath=$anapath/star/`echo $night | cut -c 1-4`/`echo $night | cut -c 5-6`/`echo $night | cut -c 7-8`
   #files=`find $inpath -name '*_I.root'`
   files=( `ls $inpath/*_I.root 2>/dev/null` )
   if [ ${#files[@]} -eq 0 ]
   then
      continue
   fi
   echo "files: "${#files[@]}
   for file in ${files[@]}
   do 
      run=`basename $file | cut -d_ -f2`
      query="SELECT fSourceKey FROM RunInfo WHERE fNight="$night" AND fRunID="$run" GROUP BY fSourceKey"
      source=`sendquery`
      if [ $source -eq 0 ]
      then
         continue
      fi
      dspath=$anapath/datasets_night/$source
      dsfile=$dspath"/dataset"$night".txt"
      if ! grep `basename $file` $dsfile >/dev/null 2>&1
      then 
         if echo $resulttable1 | grep ISDC >/dev/null 2>&1
         then 
            query="SELECT LPAD(fSequenceID, 3, 0) FROM RunInfo WHERE fNight="$night" AND fRunID="$run
            seq=`sendquery`
            merpplog=`dirname $file`"/"$night"_"$seq"-merpp.log"
         else 
            merpplog=`echo $file | sed -e 's/_I.root/-merpp.log/'`
         fi
         echo $merpplog	
         stillrunning=`find $merpplog -mmin -1 2>/dev/null`
         if [ -e $merpplog ] && [ "$stillrunning" == "" ]
         then
            echo `dirname $file`" "`basename $file` >> $dsfile
            echo `dirname $file`" "`basename $file`
         else
            printprocesslog "INFO merpp still running - wait with file "$file
            continue
         fi
      fi
   done
   
   for source in ${sources[@]}
   do 
      dspath=$anapath/datasets_night/$source
      dsfile=$dspath"/dataset"$night".txt"
      if ls $dsfile >/dev/null 2>&1
      then
         lines=( `wc -l $dsfile` )
         linesnew[$source]=${lines[0]}
         if [ ${lines[0]} -le 1 ]
         then
            # not ideal - what if number of files stays the same, but files change?
            rm -v $dsfile
            continue
         fi
         echo "new: "${linesnew[$source]}
         echo "old: "${linesold[$source]}
         if [ ${linesnew[$source]} -le ${linesold[$source]} ]
         then
            echo "nothing new"
            continue
         else
            ls $dsfile
         fi
      fi
      query="SELECT Round(fRightAscension,6), Round(fDeclination,6) from source WHERE fSourceKey="$source
      coordinates=( `sendquery` )
      if [ "${coordinates[0]}" == "" ] || [ "${coordinates[1]}" == "" ]
      then
         printprocesslog "WARN couldn't get coordinates ("${coordinates[@]}") from "$drivefile
         #echo "WARN couldn't get coordinates ("${coordinates[@]}") from "$drivefile
         continue
      fi
      if [ "${coordinates[0]}" == "0" ] || [ "${coordinates[1]}" == "0" ]
      then
         printprocesslog "WARN coordinates "${coordinates[@]}
         #echo "WARN coordinates "${coordinates[@]}
         continue
      fi
      if ls $dsfile >/dev/null 2>&1
      then
         outpath=$anapath/ganymeds_night/$source
         logfile=$outpath"/ganymed"$night".log"
         echo $logfile
         #ls $logfile
         if ! ls $logfile >/dev/null 2>&1
         then
            ls $dsfile
            if [ "$qlasge" = "yes" ]
            then
               printprocesslog "$sgepath/qsub -b y -q fact_short -v AUTOMATIONSETUP=$AUTOMATIONSETUP -v dsfile=$dsfile -v ra=${coordinates[0]} -v dec=${coordinates[1]} -e bla.txt -o bla.txt `dirname $0`/RunGanymed.sh"
               $sgepath/qsub -b y -q fact_short -v AUTOMATIONSETUP=$AUTOMATIONSETUP -v dsfile=$dsfile -v ra=${coordinates[0]} -v dec=${coordinates[1]} -e bla.txt -o bla.txt `dirname $0`/RunGanymed.sh
            else
               `dirname $0`/RunGanymed.sh $dsfile ${coordinates[0]} ${coordinates[1]}
            fi
            #echo "`dirname $0`/RunGanymed.sh $source $dsfile"
            #`dirname $0`/RunGanymed.sh $source $dsfile
            numganymeds=`echo " $numganymeds + 1 " | bc -l`
         fi
      fi
   done

   echo "found "$numganymeds" ganymeds."
done

finish
