#!/bin/bash

# script to fill moon information to DB
# doesn't need raw files
# probably doesn't run at ISDC (FACT++/moon missing)

# option whether to fill all row or only those where information is missing
# $doupdate might be given as environment variable
if [ "$doupdate" = "" ]
then
   doupdate="yes" # update all entries (needed when new fields have been added)
   doupdate="no" # fill only entries which are not yet existing (default)
fi

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 with option doupdate="$doupdate

# get dates
if [ "$certaindate" != "" ]
then
   getdates $certaindate
else
   # get all night
   #getdates "all"
   # get last 6 nights
   getdates 6
fi

printprocesslog "INFO processing the following night(s): "${dates[@]}

# do filling of aux data 
for date in ${dates[@]}
do 
   runnumber=`echo $date | sed -e 's/\///g'`
   if [ $runnumber -lt 20111115 ]
   then
      continue
   fi
   printprocesslog "INFO processing date "$date

   # get file numbers from DB
   #   but only for not-corrupted files
   query="SELECT fRunID from RunInfo WHERE fNight="$runnumber" AND NOT ISNULL(fRunStart) "
   if [ "$doupdate" = "no" ]
   then
      query=$query" AND ISNULL(fMoonDisk) "
   fi
   printprocesslog "DEBUG get filenumbers from DB: QUERY: "$query
   # proceed only if there are files available
   filenumbers=( `sendquery` )
   if [ ${#filenumbers} -eq 0 ]
   then
      printprocesslog "INFO No files found in the DB for night "$date
      continue
   fi

   # fill auxiliary information for files
   for filenum in ${filenumbers[@]}
   do
      printprocesslog "INFO processing file number "$runnumber"_"`printf %03d $filenum`
      
      # get input info from DB 
      #  query 999 in case value is empty to easily recognize this case
      query="SELECT if (isnull(fRightAscension), 999, fRightAscension), "
      query=$query" if (isnull(fDeclination), 999, fDeclination), "
      query=$query" fRunStart from RunInfo "
      query=$query" WHERE fNight="$runnumber" AND fRunID="$filenum
      info=( `sendquery` )
      if [ "${info[0]}" == "999" ] && [ "${info[1]}" == "999" ]
      then 
         lightinfo=( `$factpath/moon "${info[2]} ${info[3]}" 2>/dev/null` )
      else
         lightinfo=( `$factpath/moon "${info[2]} ${info[3]}" --ra=${info[0]} --dec=${info[1]} 2>/dev/null` )
      fi
      # return values of the programm
      # timestamp sunzd moon-visible moondisk moonzd angletomoon angletosun
      
      # build query to update runinfo in DB
      query="UPDATE RunInfo SET fSunZenithDistance="${lightinfo[2]}", fMoonDisk="${lightinfo[4]}
      query=$query", fMoonZenithDistance="${lightinfo[5]}
      if [ "${info[0]}" != "999" ] && [ "${info[1]}" != "999" ]
      then 
         query=$query", fAngleToMoon="${lightinfo[6]}
         query=$query", fAngleToSun="${lightinfo[7]}
      fi
      # add where condition
      query=$query" WHERE fNight="$runnumber" AND fRunID="$filenum

      # send query to DB
      sendquery >/dev/null
   done
done

finish


